/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.migration;

import diskCacheV111.namespace.NameSpaceProvider;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Map;
import org.dcache.auth.Subjects;
import org.dcache.chimera.migration.PnfsIdValidator;
import org.dcache.namespace.FileAttribute;

public class StorageInfoComparator
implements PnfsIdValidator {
    private final PrintStream _pw;
    private final NameSpaceProvider _nsp1;
    private final String _nsp1Name;
    private final NameSpaceProvider _nsp2;
    private final String _nsp2Name;

    public StorageInfoComparator(NameSpaceProvider nsp1, NameSpaceProvider nsp2) {
        this(null, nsp1, nsp2);
    }

    public StorageInfoComparator(PrintStream pw, NameSpaceProvider nsp1, NameSpaceProvider nsp2) {
        this(pw, nsp1, nsp1.getClass().getSimpleName(), nsp2, nsp2.getClass().getSimpleName());
    }

    public StorageInfoComparator(PrintStream pw, NameSpaceProvider nsp1, String name1, NameSpaceProvider nsp2, String name2) {
        this._pw = pw;
        this._nsp1 = nsp1;
        this._nsp1Name = name1;
        this._nsp2 = nsp2;
        this._nsp2Name = name2;
    }

    @Override
    public boolean isOK(PnfsId pnfsId) {
        StorageInfo si2;
        StorageInfo si1;
        try {
            si1 = this._nsp1.getFileAttributes(Subjects.ROOT, pnfsId, EnumSet.of(FileAttribute.STORAGEINFO)).getStorageInfo();
        }
        catch (IllegalArgumentException e) {
            if (this._pw != null) {
                this._pw.println("Failed to obtain StorageInfo from " + this._nsp1Name + ": " + e.getMessage());
            }
            return false;
        }
        catch (CacheException e) {
            if (this._pw != null) {
                this._pw.println("Failed to obtain StorageInfo from " + this._nsp1Name + ": " + e.getMessage());
            }
            return false;
        }
        try {
            si2 = this._nsp2.getFileAttributes(Subjects.ROOT, pnfsId, EnumSet.of(FileAttribute.STORAGEINFO)).getStorageInfo();
        }
        catch (IllegalArgumentException e) {
            if (this._pw != null) {
                this._pw.println("Failed to obtain StorageInfo from " + this._nsp2Name + ": " + e.getMessage());
            }
            return false;
        }
        catch (CacheException e) {
            if (this._pw != null) {
                this._pw.println("Failed to obtain StorageInfo from " + this._nsp2Name + ": " + e.getMessage());
            }
            return false;
        }
        if (si1 == null && si2 == null) {
            return true;
        }
        if (si1 == null) {
            if (this._pw != null) {
                this._pw.println("ID " + pnfsId + " has null " + this._nsp1Name + " StorageInfo");
            }
            return false;
        }
        this.removeAllKeys(si1);
        this.removeAllKeys(si2);
        if (si1.equals(si2)) {
            return true;
        }
        if (this._pw != null) {
            this._pw.println("ID " + pnfsId + " failed consistency check for Storage Info.");
            this._pw.println("\t" + this._nsp1Name + ":");
            this._pw.println("\t\t" + si1);
            this._pw.println("\t" + this._nsp2Name + ":");
            this._pw.println("\t\t" + si2);
        }
        return false;
    }

    private void removeAllKeys(StorageInfo si) {
        Map keyMap = si.getMap();
        for (String key : keyMap.keySet()) {
            si.setKey(key, null);
        }
    }
}

