/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.migration;

import diskCacheV111.util.PnfsId;
import java.io.BufferedReader;
import java.io.IOException;
import org.dcache.chimera.migration.TerminableBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PnfsIdProducer
implements Runnable {
    public static final Logger _log = LoggerFactory.getLogger(PnfsIdProducer.class);
    public static final String THREAD_NAME = "file reader";
    private final TerminableBlockingQueue<PnfsId> _queue;
    private final BufferedReader _reader;
    private Thread _thread;
    private int _lineCount = 0;

    public PnfsIdProducer(BufferedReader reader, TerminableBlockingQueue<PnfsId> targetQueue) {
        this._queue = targetQueue;
        this._reader = reader;
    }

    public synchronized void start() {
        _log.debug("Checking if we should start the reader thread");
        if (this._thread == null) {
            _log.info("Creating reader thread");
            this._thread = new Thread((Runnable)this, THREAD_NAME);
            this._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        _log.debug("Reader thread started");
        try {
            this.readFileContents();
        }
        finally {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {}
            if (!this._queue.isTerminated()) {
                this._queue.terminate();
            }
        }
        _log.debug("Reader thread completed OK.");
    }

    private void readFileContents() {
        try {
            String rawLine;
            while ((rawLine = this._reader.readLine()) != null && !this._queue.isTerminated()) {
                this.processLine(rawLine.trim());
            }
        }
        catch (IOException e) {
            _log.error("Problem reading file: " + e.getMessage());
        }
        catch (InterruptedException e) {
            _log.error("Reader thread interrupted after reading " + this._lineCount + " lines");
        }
    }

    private void processLine(String line) throws InterruptedException {
        PnfsId pnfsId;
        ++this._lineCount;
        if (line.startsWith("#") || line.length() == 0) {
            return;
        }
        try {
            pnfsId = new PnfsId(line);
        }
        catch (IllegalArgumentException e) {
            _log.warn("\nSkipping malformed ID on line " + this._lineCount);
            return;
        }
        this._queue.put(pnfsId);
    }
}

