/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.migration;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.dcache.chimera.migration.AbstractTerminableBlockingQueueDecorator;
import org.dcache.chimera.migration.TerminableBlockingQueue;

public class LoggingTerminableBlockingQueueDecorator<E>
extends AbstractTerminableBlockingQueueDecorator<E> {
    public static final int IDS_PER_LINE = 1000;
    public static final int IDS_PER_DOT = 20;
    private final PrintStream _stream;
    private int _addedItemsCount = 0;
    private long _startTime = 0L;
    private long _whenLastNewLine = 0L;
    private final String _itemDescription;

    public LoggingTerminableBlockingQueueDecorator(TerminableBlockingQueue<E> queue, PrintStream stream, String itemDescription) {
        super(queue);
        this._stream = stream;
        this._itemDescription = itemDescription;
    }

    @Override
    public boolean add(E item) {
        super.add(item);
        this.itemAdded();
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int initialSize = this.size();
        boolean itemsAdded = super.addAll(c);
        int finalSize = this.size();
        for (int count = initialSize; count < finalSize; ++count) {
            this.itemAdded();
        }
        return itemsAdded;
    }

    @Override
    public boolean offer(E item) {
        boolean addedItem = super.offer(item);
        if (addedItem) {
            this.itemAdded();
        }
        return addedItem;
    }

    @Override
    public void put(E item) throws InterruptedException {
        super.put(item);
        this.itemAdded();
    }

    @Override
    public void terminate() {
        super.terminate();
        this.emitFinalStatistics();
    }

    private void itemAdded() {
        if (this._startTime == 0L) {
            this._startTime = System.currentTimeMillis();
        }
        if (this._addedItemsCount % 1000 == 0) {
            long now = System.currentTimeMillis();
            if (this._addedItemsCount > 0) {
                double freq = 1000000.0 / (double)(now - this._whenLastNewLine);
                this._stream.println(" [ " + String.format("%6.1f", freq) + " Hz]");
            }
            this._whenLastNewLine = now;
            this._stream.print("Read " + String.format("%6d", this._addedItemsCount) + " " + this._itemDescription);
            this._stream.print(": ");
            this._stream.flush();
        } else if (this._addedItemsCount % 20 == 0) {
            this._stream.print(".");
            this._stream.flush();
        }
        ++this._addedItemsCount;
    }

    public void emitFinalStatistics() {
        long elapsedTime = System.currentTimeMillis() - this._startTime;
        double freq = (double)this._addedItemsCount / (double)TimeUnit.SECONDS.convert(elapsedTime, TimeUnit.MILLISECONDS);
        long elapsedDays = TimeUnit.DAYS.convert(elapsedTime, TimeUnit.MILLISECONDS);
        long elapsedTimeLessDays = elapsedTime - TimeUnit.MILLISECONDS.convert(elapsedDays, TimeUnit.DAYS);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String days = elapsedDays > 1L ? "days" : "day";
        this._stream.println("\nIn total, checked " + this._addedItemsCount + " " + this._itemDescription + " in " + (elapsedDays > 0L ? elapsedDays + " " + days + " " : "") + format.format(new Date(elapsedTimeLessDays)) + " [" + String.format("%.1f", freq) + " Hz]");
    }
}

