/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.migration;

import diskCacheV111.namespace.NameSpaceProvider;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.PnfsId;
import java.io.PrintStream;
import org.dcache.auth.Subjects;
import org.dcache.chimera.migration.PnfsIdValidator;

public class FileMetaDataComparator
implements PnfsIdValidator {
    private final PrintStream _pw;
    private final NameSpaceProvider _nsp1;
    private final NameSpaceProvider _nsp2;
    private final String _nsp1Name;
    private final String _nsp2Name;

    public FileMetaDataComparator(NameSpaceProvider nsp1, NameSpaceProvider nsp2) {
        this(null, nsp1, nsp1.getClass().getSimpleName(), nsp2, nsp2.getClass().getSimpleName());
    }

    public FileMetaDataComparator(PrintStream pw, NameSpaceProvider nsp1, NameSpaceProvider nsp2) {
        this(pw, nsp1, nsp1.getClass().getSimpleName(), nsp2, nsp2.getClass().getSimpleName());
    }

    public FileMetaDataComparator(PrintStream pw, NameSpaceProvider nsp1, String name1, NameSpaceProvider nsp2, String name2) {
        this._pw = pw;
        this._nsp1 = nsp1;
        this._nsp1Name = name1;
        this._nsp2 = nsp2;
        this._nsp2Name = name2;
    }

    @Override
    public boolean isOK(PnfsId pnfsId) {
        FileMetaData fmd2;
        FileMetaData fmd1;
        try {
            fmd1 = new FileMetaData(this._nsp1.getFileAttributes(Subjects.ROOT, pnfsId, FileMetaData.getKnownFileAttributes()));
        }
        catch (IllegalArgumentException e) {
            if (this._pw != null) {
                this._pw.println("Failed to obtain FileMetaData from " + this._nsp1Name + ": " + e.getMessage());
            }
            return false;
        }
        catch (CacheException e) {
            if (this._pw != null) {
                this._pw.println("Failed to obtain FileMetaData from " + this._nsp1Name + ": " + e.getMessage());
            }
            return false;
        }
        try {
            fmd2 = new FileMetaData(this._nsp2.getFileAttributes(Subjects.ROOT, pnfsId, FileMetaData.getKnownFileAttributes()));
        }
        catch (IllegalArgumentException e) {
            if (this._pw != null) {
                this._pw.println("Failed to obtain FileMetaData from " + this._nsp2Name + ": " + e.getMessage());
            }
            return false;
        }
        catch (CacheException e) {
            if (this._pw != null) {
                this._pw.println("Failed to obtain FileMetaData from " + this._nsp2Name + ": " + e.getMessage());
            }
            return false;
        }
        if (fmd1 == null && fmd2 == null) {
            return true;
        }
        if (fmd1 == null) {
            if (this._pw != null) {
                this._pw.println("ID " + pnfsId + " has null FileMetaData from " + this._nsp1Name);
            }
            return false;
        }
        if (fmd1.equals((Object)fmd2)) {
            return true;
        }
        if (this._pw != null) {
            this._pw.println("ID " + pnfsId + " failed consistency check for File Metadata.");
            this._pw.println("\t" + this._nsp1Name + ":");
            this._pw.println("\t\t" + fmd1);
            this._pw.println("\t" + this._nsp2Name + ":");
            this._pw.println("\t\t" + fmd2);
            this.emitDifferences(fmd1, fmd2);
        }
        return false;
    }

    private void emitDifferences(FileMetaData fmd1, FileMetaData fmd2) {
        this._pw.println("\tDifferences:");
        if (fmd1.getGid() != fmd2.getGid()) {
            this._pw.println("\t\tgid: " + fmd1.getGid() + " != " + fmd2.getGid());
        }
        if (fmd1.getUid() != fmd2.getUid()) {
            this._pw.println("\t\tuid: " + fmd1.getUid() + " != " + fmd2.getUid());
        }
        if (fmd1.isDirectory() != fmd2.isDirectory()) {
            this._pw.println("\t\tdirectory: " + fmd1.isDirectory() + " != " + fmd2.isDirectory());
        }
        if (fmd1.isSymbolicLink() != fmd2.isSymbolicLink()) {
            this._pw.println("\t\tsym-link: " + fmd1.isSymbolicLink() + " != " + fmd2.isSymbolicLink());
        }
        if (fmd1.isRegularFile() != fmd2.isRegularFile()) {
            this._pw.println("\t\tregular file: " + fmd1.isRegularFile() + " != " + fmd2.isRegularFile());
        }
        if (fmd1.getFileSize() != fmd2.getFileSize()) {
            this._pw.println("\t\tsize: " + fmd1.getFileSize() + " != " + fmd2.getFileSize());
        }
        if (!fmd1.getUserPermissions().equals((Object)fmd2.getUserPermissions())) {
            this._pw.println("\t\tuser permissions: " + fmd1.getUserPermissions() + " != " + fmd2.getUserPermissions());
        }
        if (!fmd1.getGroupPermissions().equals((Object)fmd2.getGroupPermissions())) {
            this._pw.println("\t\tgroup permissions: " + fmd1.getGroupPermissions() + " != " + fmd2.getGroupPermissions());
        }
        if (!fmd1.getWorldPermissions().equals((Object)fmd2.getWorldPermissions())) {
            this._pw.println("\t\tworld permissions: " + fmd1.getWorldPermissions() + " != " + fmd2.getWorldPermissions());
        }
        if (fmd1.getCreationTime() != fmd2.getCreationTime()) {
            this._pw.println("\t\tcreation-time: " + fmd1.getCreationTime() + " != " + fmd2.getCreationTime());
        }
        if (fmd1.getLastAccessedTime() != fmd2.getLastAccessedTime()) {
            this._pw.println("\t\tlast-accessed: " + fmd1.getLastAccessedTime() + " != " + fmd2.getLastAccessedTime());
        }
        if (fmd1.getLastModifiedTime() != fmd2.getLastModifiedTime()) {
            this._pw.println("\t\tlast-modified: " + fmd1.getLastModifiedTime() + " != " + fmd2.getLastModifiedTime());
        }
    }
}

