/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.migration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import diskCacheV111.namespace.NameSpaceProvider;
import diskCacheV111.namespace.provider.BasicNameSpaceProvider;
import diskCacheV111.util.PnfsFile;
import diskCacheV111.util.PnfsId;
import dmg.util.Args;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.concurrent.ArrayBlockingQueue;
import org.dcache.chimera.migration.CombinedComparator;
import org.dcache.chimera.migration.FileMetaDataComparator;
import org.dcache.chimera.migration.LoggingTerminableBlockingQueueDecorator;
import org.dcache.chimera.migration.PnfsIdProducer;
import org.dcache.chimera.migration.PnfsIdValidator;
import org.dcache.chimera.migration.StorageInfoComparator;
import org.dcache.chimera.migration.TerminableBlockingQueue;
import org.dcache.chimera.migration.TerminableBlockingQueueDecorator;
import org.dcache.chimera.namespace.ChimeraNameSpaceProvider;
import org.slf4j.LoggerFactory;

public class Comparator {
    private static final String OPTION_CHIMIERA_CONFIG = "config";
    private static final String OPTION_PNFS_MOUNT = "pnfsMount";
    private static final String PNFS_ID_DESCRIPTION = "file IDs";
    private static final String FILENAME_CHIMERA_CONFIG_DEFAULT = "/opt/d-cache/config/chimera-config.xml";
    private static final String LOG_PATTERN = "%-5level - %msg%n";
    private static int _errorCount = 0;

    public static void main(String[] args) throws Exception {
        String suppliedConfigFilename;
        Args parsedArgs = new Args(args);
        if (parsedArgs.argc() != 1 || parsedArgs.isOneCharOption('h')) {
            System.err.println("Usage:");
            System.err.println("    comparator [-k] [-v] [-h] [-config=<file>] [-pnfsMount=<dir>] <file>");
            System.err.println("");
            System.err.println("where:");
            System.err.println("    -k          \tcheck should continue should an inconsistency be discovered.");
            System.err.println("    -v          \tincrease verbosity.");
            System.err.println("    -h          \thelp.");
            System.err.println("    -config=<file>\tuse <file> for Chimera configuration.");
            System.err.println("                \t(/opt/d-cache/config/chimera-config.xml by default)");
            System.err.println("    -pnfsMount=<dir>\tuse <dir> as PNFS mount-point");
            System.err.println("                \t(auto-detect by default, RECOMMENDED)");
            System.err.println("    <file>      \tcontains a list of PNFS IDs of files to verify.");
            System.exit(2);
        }
        String chimeraConfigFilename = (suppliedConfigFilename = parsedArgs.getOpt(OPTION_CHIMIERA_CONFIG)) != null ? suppliedConfigFilename : FILENAME_CHIMERA_CONFIG_DEFAULT;
        String pnfsMount = parsedArgs.getOpt(OPTION_PNFS_MOUNT);
        String file = parsedArgs.argv(0);
        boolean showAllErrors = parsedArgs.isOneCharOption('k');
        Level level = parsedArgs.isOneCharOption('v') ? Level.DEBUG : Level.WARN;
        Comparator.switchLogging("logger.org.dcache.namespace." + BasicNameSpaceProvider.class.getName(), level);
        Comparator.switchLogging("logger.dev.org.dcache.namespace." + PnfsFile.class.getName(), level);
        Comparator.switchLogging("org.dcache.chimera.migration", level);
        String pnfsArgs = "diskCacheV111.util.GenericInfoExtractor -delete-registration=dummyLocation -delete-registration-jdbcDrv=foo -delete-registration-dbUser=dummyUser -delete-registration-dbPass=dummyPass " + (pnfsMount != null ? "-pnfs=" + pnfsMount : "");
        String chimeraArgs = "org.dcache.chimera.namespace.ChimeraOsmStorageInfoExtractor -chimeraConfig=" + chimeraConfigFilename;
        PnfsIdValidator validator = Comparator.newValidator(chimeraArgs, pnfsArgs);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e1) {
            System.out.println("\nCouldn't find file " + file);
            System.exit(2);
        }
        TerminableBlockingQueue<PnfsId> queue = Comparator.newBlockingQueue();
        Comparator.addShutdownHook(queue);
        PnfsIdProducer producer = new PnfsIdProducer(br, queue);
        producer.start();
        PnfsId id = (PnfsId)queue.take();
        while (!queue.hasTerminateWith(id)) {
            if (!validator.isOK(id)) {
                ++_errorCount;
                if (!showAllErrors) {
                    queue.terminate();
                }
            }
            id = (PnfsId)queue.take();
        }
        if (_errorCount > 0) {
            System.exit(1);
        }
    }

    private static void addShutdownHook(final TerminableBlockingQueue<PnfsId> queue) {
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(){
            TerminableBlockingQueue<PnfsId> _queue;
            {
                this._queue = queue;
            }

            @Override
            public void run() {
                if (!this._queue.isTerminated()) {
                    this._queue.terminate();
                }
                Comparator.emitErrorCount();
            }
        });
    }

    private static void emitErrorCount() {
        if (_errorCount > 0) {
            System.out.println(_errorCount + " failure" + (_errorCount > 1 ? "s" : "") + " discovered.");
        } else {
            System.out.println("All IDs are OK.");
        }
    }

    private static void switchLogging(String name, Level level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ConsoleAppender ca = new ConsoleAppender();
        ca.setContext((Context)loggerContext);
        ca.setName(name);
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext((Context)loggerContext);
        pl.setPattern(LOG_PATTERN);
        pl.start();
        ca.setEncoder((Encoder)pl);
        ca.start();
        Logger logger = loggerContext.getLogger(name);
        logger.detachAndStopAllAppenders();
        logger.addAppender((Appender)ca);
        logger.setLevel(level);
    }

    private static TerminableBlockingQueue<PnfsId> newBlockingQueue() {
        ArrayBlockingQueue idQueue = new ArrayBlockingQueue(1, true);
        PnfsId sentinel = new PnfsId("0000000000000000000000");
        TerminableBlockingQueueDecorator<PnfsId> terminableQueue = new TerminableBlockingQueueDecorator<PnfsId>(idQueue, sentinel, 1);
        LoggingTerminableBlockingQueueDecorator<PnfsId> loggingQueue = new LoggingTerminableBlockingQueueDecorator<PnfsId>(terminableQueue, System.out, PNFS_ID_DESCRIPTION);
        return loggingQueue;
    }

    private static PnfsIdValidator newValidator(String chimeraArgs, String pnfsArgs) throws Exception {
        ChimeraNameSpaceProvider chimeraNamespace = new ChimeraNameSpaceProvider();
        BasicNameSpaceProvider pnfsNamespace = new BasicNameSpaceProvider(pnfsArgs);
        FileMetaDataComparator checkFileMetaData = new FileMetaDataComparator(System.err, (NameSpaceProvider)chimeraNamespace, (NameSpaceProvider)pnfsNamespace);
        StorageInfoComparator checkStorageInfo = new StorageInfoComparator(System.err, (NameSpaceProvider)chimeraNamespace, (NameSpaceProvider)pnfsNamespace);
        CombinedComparator combinedComparator = new CombinedComparator(checkFileMetaData, checkStorageInfo);
        return combinedComparator;
    }
}

