/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commandline.test;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.freehep.util.commandline.CommandLine;
import org.freehep.util.commandline.CommandLineException;
import org.freehep.util.commandline.MissingArgumentException;
import org.freehep.util.commandline.NoSuchOptionException;

public class CommandLineUnitTest
extends TestCase {
    private CommandLine cl;
    static /* synthetic */ Class class$0;

    public CommandLineUnitTest(String name) {
        super(name);
    }

    protected void setUp() {
        String cmd = "Fake Java Virtual Machine (version 0.9)";
        this.cl = new CommandLine("java", cmd, 3);
        this.cl.addOption("classpath", "cp", "path", "set search path for application classes");
        this.cl.addBailOutOption("help", "h", "show help on command");
        this.cl.addOption("notSetFlag", "nsf", "never used");
        this.cl.addOption("notSetOption", "nso", "dummy", "not used");
        this.cl.addOption("notSetQualifiedFlag", null, new String[]{"dummy"}, "not used");
        this.cl.addOption("startup", "st", "startup time", "specify startup time");
        this.cl.addOption("verbose", "v", new String[]{"class", "gc", "jni"}, "enable verbose output");
        this.cl.addBailOutOption("version", null, "print product version");
        this.cl.addOption("x", null, "option x");
        this.cl.addOption("y", null, "option y");
        this.cl.addMultiOption("I", "includedir", "add includedir to search path");
        this.cl.addMultiOption("D", "key=value", "define a property");
        this.cl.addParameter("class1", "first classfile");
        this.cl.addParameter("class2", "second classfile");
        this.cl.addParameter("class3", "third classfile");
        this.cl.addParameter("optionalfile", "optional classfile");
        this.cl.addParameter("args...", "further arguments");
    }

    public void testVersion() throws CommandLineException {
        CommandLineUnitTest.assertTrue((!this.cl.parse(new String[]{"-version"}) ? 1 : 0) != 0);
        CommandLineUnitTest.assertTrue((boolean)this.cl.hasOption("version"));
    }

    public void testDoubleVersion() throws CommandLineException {
        CommandLineUnitTest.assertTrue((!this.cl.parse(new String[]{"--version"}) ? 1 : 0) != 0);
        CommandLineUnitTest.assertTrue((boolean)this.cl.hasOption("version"));
    }

    public void testHelp() throws CommandLineException {
        CommandLineUnitTest.assertTrue((!this.cl.parse(new String[]{"-help"}) ? 1 : 0) != 0);
        CommandLineUnitTest.assertTrue((boolean)this.cl.hasOption("help"));
    }

    public void testH() throws CommandLineException {
        CommandLineUnitTest.assertTrue((!this.cl.parse(new String[]{"-h"}) ? 1 : 0) != 0);
        CommandLineUnitTest.assertTrue((boolean)this.cl.hasOption("h"));
    }

    public void testOptionParameters() throws CommandLineException {
        CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-verbose", "parameter1", "parameter2", "parameter3"}));
        CommandLineUnitTest.assertTrue((boolean)this.cl.hasOption("verbose"));
        CommandLineUnitTest.assertTrue((boolean)this.cl.hasOption("v"));
        String[] args = this.cl.getArguments();
        CommandLineUnitTest.assertEquals((String)"parameter1", (String)args[0]);
        CommandLineUnitTest.assertEquals((String)"parameter2", (String)args[1]);
        CommandLineUnitTest.assertEquals((String)"parameter3", (String)args[2]);
    }

    public void testDoubleOptionParameters() throws CommandLineException {
        CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-x-y", "parameter1", "parameter2", "parameter3"}));
        CommandLineUnitTest.assertTrue((boolean)this.cl.hasOption("x"));
        CommandLineUnitTest.assertTrue((boolean)this.cl.hasOption("y"));
        String[] args = this.cl.getArguments();
        CommandLineUnitTest.assertEquals((String)"parameter1", (String)args[0]);
        CommandLineUnitTest.assertEquals((String)"parameter2", (String)args[1]);
        CommandLineUnitTest.assertEquals((String)"parameter3", (String)args[2]);
    }

    public void testValueOptionParametersOptional() throws CommandLineException {
        CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-cp", "classpath", "parameter1", "parameter2", "parameter3", "optional1", "optional2"}));
        CommandLineUnitTest.assertEquals((String)"classpath", (String)this.cl.getOption("classpath"));
        CommandLineUnitTest.assertEquals((String)"classpath", (String)this.cl.getOption("cp"));
        String[] args = this.cl.getArguments();
        CommandLineUnitTest.assertEquals((String)"parameter1", (String)args[0]);
        CommandLineUnitTest.assertEquals((String)"parameter2", (String)args[1]);
        CommandLineUnitTest.assertEquals((String)"parameter3", (String)args[2]);
        CommandLineUnitTest.assertEquals((String)"optional1", (String)args[3]);
        CommandLineUnitTest.assertEquals((String)"optional2", (String)args[4]);
    }

    public void testQualifiedOptionParametersOptional() throws CommandLineException {
        CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-verbose:gc", "parameter1", "parameter2", "parameter3", "optional1"}));
        CommandLineUnitTest.assertEquals((String)"gc", (String)this.cl.getOption("verbose"));
        CommandLineUnitTest.assertEquals((String)"gc", (String)this.cl.getOption("v"));
        String[] args = this.cl.getArguments();
        CommandLineUnitTest.assertEquals((String)"parameter1", (String)args[0]);
        CommandLineUnitTest.assertEquals((String)"parameter2", (String)args[1]);
        CommandLineUnitTest.assertEquals((String)"parameter3", (String)args[2]);
        CommandLineUnitTest.assertEquals((String)"optional1", (String)args[3]);
    }

    public void testMultiOptionSingle() throws CommandLineException {
        CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-Iincludedir1", "par1", "par2", "par3"}));
        Vector multi = this.cl.getMultiOption("I");
        CommandLineUnitTest.assertEquals((Object)"includedir1", multi.get(0));
        String[] args = this.cl.getArguments();
        CommandLineUnitTest.assertEquals((String)"par1", (String)args[0]);
        CommandLineUnitTest.assertEquals((String)"par2", (String)args[1]);
        CommandLineUnitTest.assertEquals((String)"par3", (String)args[2]);
    }

    public void testMultiOptionMulti() throws CommandLineException {
        CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-Iincludedir1", "-Iincludedir2", "par1", "par2", "par3"}));
        Vector multi = this.cl.getMultiOption("I");
        CommandLineUnitTest.assertEquals((Object)"includedir1", multi.get(0));
        CommandLineUnitTest.assertEquals((Object)"includedir2", multi.get(1));
        String[] args = this.cl.getArguments();
        CommandLineUnitTest.assertEquals((String)"par1", (String)args[0]);
        CommandLineUnitTest.assertEquals((String)"par2", (String)args[1]);
        CommandLineUnitTest.assertEquals((String)"par3", (String)args[2]);
    }

    public void testKeyValuePairs() throws CommandLineException {
        CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-Dvar1=value1", "-Dvar2=value2", "par1", "par2", "par3"}));
        Vector key = this.cl.getMultiOption("D");
        CommandLineUnitTest.assertEquals((Object)"var1=value1", key.get(0));
        CommandLineUnitTest.assertEquals((Object)"var2=value2", key.get(1));
        String[] args = this.cl.getArguments();
        CommandLineUnitTest.assertEquals((String)"par1", (String)args[0]);
        CommandLineUnitTest.assertEquals((String)"par2", (String)args[1]);
        CommandLineUnitTest.assertEquals((String)"par3", (String)args[2]);
    }

    public void testUnknownKeyValueOption() throws CommandLineException {
        try {
            CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-startup=now", "classpath", "parameter1", "parameter2", "parameter3"}));
        }
        catch (NoSuchOptionException nsoe) {
            return;
        }
        CommandLineUnitTest.fail((String)"Expected NoSuchOptionException");
    }

    public void testUnknownFlag() throws CommandLineException {
        try {
            CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-unknownflag", "parameter1", "parameter2", "parameter3"}));
        }
        catch (NoSuchOptionException nsoe) {
            return;
        }
        CommandLineUnitTest.fail((String)"Expected NoSuchOptionException");
    }

    public void testUnknownOption() throws CommandLineException {
        try {
            CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-unknownoption", "somevalue", "parameter1", "parameter2", "parameter3"}));
        }
        catch (NoSuchOptionException nsoe) {
            return;
        }
        CommandLineUnitTest.fail((String)"Expected NoSuchOptionException");
    }

    public void testMissingArgument() throws CommandLineException {
        try {
            CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-verbose", "too", "few parameters"}));
        }
        catch (MissingArgumentException mae) {
            return;
        }
        CommandLineUnitTest.fail((String)"Expected MissingArgumentException");
    }

    public void testMissingValue() throws CommandLineException {
        try {
            CommandLineUnitTest.assertTrue((boolean)this.cl.parse(new String[]{"-cp"}));
        }
        catch (MissingArgumentException mae) {
            return;
        }
        CommandLineUnitTest.fail((String)"Expected MissingArgumentException");
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freehep.util.commandline.test.CommandLineUnitTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CommandLineUnitTest.suite());
    }
}

