/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commandline.test;

import org.freehep.util.commandline.CommandLine;
import org.freehep.util.commandline.CommandLineException;

public class CommandLineTest {
    public static void main(String[] args) {
        String[][] test = new String[][]{{"-version"}, {"--version"}, {"-verbose", "parameter1", "parameter2", "parameter3"}, {"-x-y", "parameter1", "parameter2", "parameter3"}, {"-cp", "classpath", "parameter1", "parameter2", "parameter3", "optional1", "optional2"}, {"-verbose:gc", "parameter1", "parameter2", "parameter3", "optional1"}, {"-startup=now", "classpath", "parameter1", "parameter2", "parameter3"}, {"-unknownflag", "parameter1", "parameter2", "parameter3"}, {"-unknownoption", "somevalue", "parameter1", "parameter2", "parameter3"}, {"-help"}, {"-h"}, {"-verbose", "too", "few parameters"}, {"-cp"}, {"-Iincludedir1", "par1", "par2", "par3"}, {"-Iincludedir1", "-Iincludedir2", "par1", "par2", "par3"}, {"-Dvar1=value1", "-Dvar2=value2", "classpath", "parameter1", "parameter2", "parameter3"}};
        String cmd = "Fake Java Virtual Machine (version 0.9)";
        int i = 0;
        while (i < test.length) {
            CommandLine cl = new CommandLine("java", cmd, 3);
            cl.addOption("classpath", "cp", "path", "set search path for application classes");
            cl.addBailOutOption("help", "h", "show help on command");
            cl.addOption("notSetFlag", "nsf", "never used");
            cl.addOption("notSetOption", "nso", "dummy", "not used");
            cl.addOption("notSetQualifiedFlag", null, new String[]{"dummy"}, "not used");
            cl.addOption("startup", "st", "startup time", "specify startup time");
            cl.addOption("verbose", "v", new String[]{"class", "gc", "jni"}, "enable verbose output");
            cl.addBailOutOption("version", null, "print product version");
            cl.addOption("x", null, "option x");
            cl.addOption("y", null, "option y");
            cl.addMultiOption("I", "includedir", "add includedir to search path");
            cl.addMultiOption("D", "key=value", "define a property");
            cl.addParameter("class1", "first classfile");
            cl.addParameter("class2", "second classfile");
            cl.addParameter("class3", "third classfile");
            cl.addParameter("optionalfile", "optional classfile");
            cl.addParameter("args...", "further arguments");
            try {
                int j = 0;
                while (j < test[i].length) {
                    System.out.print(String.valueOf(test[i][j]) + " ");
                    ++j;
                }
                System.out.println();
                if (!cl.parse(test[i])) {
                    if (cl.hasOption("help")) {
                        System.out.println(cl.getHelp());
                    } else if (cl.hasOption("version")) {
                        System.out.println(cmd);
                    } else {
                        System.out.println("Command Bailed Out: " + cl);
                    }
                } else {
                    System.out.println("Command OK: " + cl);
                }
            }
            catch (CommandLineException cle) {
                System.out.println(cle);
                System.out.println(cl);
            }
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            ++i;
        }
    }
}

