/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import dmg.cells.nucleus.EnvironmentAware;
import dmg.util.Args;
import dmg.util.Formats;
import dmg.util.Replaceable;
import java.io.File;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Subjects;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.cells.CellCommandListener;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.GPlazma;
import org.dcache.gplazma.NoSuchPrincipalException;
import org.dcache.gplazma.configuration.ConfigurationLoadingStrategy;
import org.dcache.gplazma.configuration.FromFileConfigurationLoadingStrategy;
import org.dcache.gplazma.monitor.LoginMonitor;
import org.dcache.gplazma.monitor.LoginResult;
import org.dcache.gplazma.monitor.LoginResultPrinter;
import org.dcache.gplazma.monitor.RecordingLoginMonitor;
import org.springframework.beans.factory.annotation.Required;

public class Gplazma2LoginStrategy
implements LoginStrategy,
EnvironmentAware,
CellCommandListener {
    private String _configurationFile;
    private GPlazma _gplazma;
    private Map<String, Object> _environment = Collections.emptyMap();
    public static final String fh_explain_login = "This command runs a test login with the supplied principals\nThe result is tracked and an explanation is provided of how \nthe result was obtained.\n";
    public static final String hh_explain_login = "<principal> [<principal> ...] # explain the result of login";

    @Required
    public void setConfigurationFile(String configurationFile) {
        if (configurationFile == null || configurationFile.length() == 0) {
            throw new IllegalArgumentException("configuration file argument wasn't specified correctly");
        }
        if (!new File(configurationFile).exists()) {
            throw new IllegalArgumentException("configuration file does not exists at " + configurationFile);
        }
        this._configurationFile = configurationFile;
    }

    public String getConfigurationFile() {
        return this._configurationFile;
    }

    public void setEnvironment(Map<String, Object> environment) {
        this._environment = environment;
    }

    public Map<String, Object> getEnvironment() {
        return this._environment;
    }

    public Properties getEnvironmentAsProperties() {
        Replaceable replaceable = new Replaceable(){

            public String getReplacement(String name) {
                Object value = Gplazma2LoginStrategy.this._environment.get(name);
                return value == null ? null : value.toString();
            }
        };
        Properties properties = new Properties();
        for (Map.Entry<String, Object> e : this._environment.entrySet()) {
            String key = e.getKey();
            String value = String.valueOf(e.getValue());
            properties.put(key, Formats.replaceKeywords((String)value, (Replaceable)replaceable));
        }
        return properties;
    }

    public void init() {
        FromFileConfigurationLoadingStrategy configuration = new FromFileConfigurationLoadingStrategy(this._configurationFile);
        this._gplazma = new GPlazma((ConfigurationLoadingStrategy)configuration, this.getEnvironmentAsProperties());
    }

    static LoginReply convertLoginReply(org.dcache.gplazma.LoginReply gPlazmaLoginReply) {
        Set sessionAttributes = gPlazmaLoginReply.getSessionAttributes();
        HashSet loginAttributes = Sets.newHashSet((Iterable)Iterables.filter((Iterable)sessionAttributes, LoginAttribute.class));
        return new LoginReply(gPlazmaLoginReply.getSubject(), (Set)loginAttributes);
    }

    public LoginReply login(Subject subject) throws CacheException {
        try {
            return Gplazma2LoginStrategy.convertLoginReply(this._gplazma.login(subject));
        }
        catch (AuthenticationException e) {
            throw new PermissionDeniedCacheException("login failed");
        }
    }

    public Principal map(Principal principal) throws CacheException {
        try {
            return this._gplazma.map(principal);
        }
        catch (NoSuchPrincipalException e) {
            return null;
        }
    }

    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        try {
            return this._gplazma.reverseMap(principal);
        }
        catch (NoSuchPrincipalException e) {
            return Collections.emptySet();
        }
    }

    public String ac_explain_login_$_1_99(Args args) {
        Subject subject = Subjects.subjectFromArgs((List)args.getArguments());
        RecordingLoginMonitor monitor = new RecordingLoginMonitor();
        try {
            this._gplazma.login(subject, (LoginMonitor)monitor);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        LoginResult result = monitor.getResult();
        LoginResultPrinter printer = new LoginResultPrinter(result);
        return printer.print();
    }
}

