/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ThreadLocalBuffers;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.io.nio.SslSelectChannelEndPoint;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

class SelectConnector
extends AbstractLifeCycle
implements HttpClient.Connector,
Runnable {
    private final HttpClient _httpClient;
    private final Manager _selectorManager = new Manager();
    private final Map<SocketChannel, Timeout.Task> _connectingChannels = new ConcurrentHashMap<SocketChannel, Timeout.Task>();
    private SSLContext _sslContext;
    private Buffers _sslBuffers;

    SelectConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._selectorManager.start();
        final boolean direct = this._httpClient.getUseDirectBuffers();
        SSLEngine sslEngine = this._selectorManager.newSslEngine();
        final SSLSession ssl_session = sslEngine.getSession();
        ThreadLocalBuffers ssl_buffers = new ThreadLocalBuffers(){
            {
                super.setBufferSize(ssl_session.getApplicationBufferSize());
                super.setHeaderSize(ssl_session.getApplicationBufferSize());
            }

            protected Buffer newBuffer(int size) {
                return direct ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
            }

            protected Buffer newHeader(int size) {
                return direct ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
            }

            protected boolean isHeader(Buffer buffer) {
                return true;
            }

            public void setBufferSize(int size) {
            }

            public void setHeaderSize(int size) {
            }
        };
        this._sslBuffers = ssl_buffers;
        this._httpClient._threadPool.dispatch((Runnable)this);
    }

    protected void doStop() throws Exception {
        this._selectorManager.stop();
    }

    public void startConnection(HttpDestination destination) throws IOException {
        try {
            SocketChannel channel = SocketChannel.open();
            Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
            channel.socket().setTcpNoDelay(true);
            if (!this._httpClient.isConnectBlocking()) {
                channel.configureBlocking(false);
                channel.connect(address.toSocketAddress());
                this._selectorManager.register(channel, destination);
                ConnectTimeout connectTimeout = new ConnectTimeout(channel, destination);
                this._httpClient.schedule(connectTimeout, this._httpClient.getConnectTimeout());
                this._connectingChannels.put(channel, connectTimeout);
            } else {
                channel.configureBlocking(true);
                channel.socket().setSoTimeout(this._httpClient.getConnectTimeout());
                channel.socket().connect(address.toSocketAddress(), this._httpClient.getConnectTimeout());
                channel.configureBlocking(false);
                channel.socket().setSoTimeout((int)this._httpClient.getTimeout());
                this._selectorManager.register(channel, destination);
            }
        }
        catch (IOException ex) {
            destination.onConnectionFailed(ex);
        }
    }

    public void run() {
        while (this._httpClient.isRunning()) {
            try {
                this._selectorManager.doSelect(0);
            }
            catch (Exception e) {
                Log.warn((String)e.toString());
                Log.debug((Throwable)e);
                Thread.yield();
            }
        }
    }

    public static class ProxySelectChannelEndPoint
    extends SslSelectChannelEndPoint {
        private final SelectChannelEndPoint plainEndPoint;
        private volatile boolean upgraded = false;

        public ProxySelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, Buffers sslBuffers, SSLEngine engine) throws IOException {
            super(sslBuffers, channel, selectSet, key, engine);
            this.plainEndPoint = new SelectChannelEndPoint(channel, selectSet, key);
        }

        public void upgrade() {
            this.upgraded = true;
        }

        public void shutdownOutput() throws IOException {
            if (this.upgraded) {
                super.shutdownOutput();
            } else {
                this.plainEndPoint.shutdownOutput();
            }
        }

        public void close() throws IOException {
            if (this.upgraded) {
                super.close();
            } else {
                this.plainEndPoint.close();
            }
        }

        public int fill(Buffer buffer) throws IOException {
            if (this.upgraded) {
                return super.fill(buffer);
            }
            return this.plainEndPoint.fill(buffer);
        }

        public int flush(Buffer buffer) throws IOException {
            if (this.upgraded) {
                return super.flush(buffer);
            }
            return this.plainEndPoint.flush(buffer);
        }

        public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
            if (this.upgraded) {
                return super.flush(header, buffer, trailer);
            }
            return this.plainEndPoint.flush(header, buffer, trailer);
        }

        public String getLocalAddr() {
            if (this.upgraded) {
                return super.getLocalAddr();
            }
            return this.plainEndPoint.getLocalAddr();
        }

        public String getLocalHost() {
            if (this.upgraded) {
                return super.getLocalHost();
            }
            return this.plainEndPoint.getLocalHost();
        }

        public int getLocalPort() {
            if (this.upgraded) {
                return super.getLocalPort();
            }
            return this.plainEndPoint.getLocalPort();
        }

        public String getRemoteAddr() {
            if (this.upgraded) {
                return super.getRemoteAddr();
            }
            return this.plainEndPoint.getRemoteAddr();
        }

        public String getRemoteHost() {
            if (this.upgraded) {
                return super.getRemoteHost();
            }
            return this.plainEndPoint.getRemoteHost();
        }

        public int getRemotePort() {
            if (this.upgraded) {
                return super.getRemotePort();
            }
            return this.plainEndPoint.getRemotePort();
        }

        public boolean isBlocking() {
            if (this.upgraded) {
                return super.isBlocking();
            }
            return this.plainEndPoint.isBlocking();
        }

        public boolean isBufferred() {
            if (this.upgraded) {
                return super.isBufferred();
            }
            return this.plainEndPoint.isBufferred();
        }

        public boolean blockReadable(long millisecs) throws IOException {
            if (this.upgraded) {
                return super.blockReadable(millisecs);
            }
            return this.plainEndPoint.blockReadable(millisecs);
        }

        public boolean blockWritable(long millisecs) throws IOException {
            if (this.upgraded) {
                return super.blockWritable(millisecs);
            }
            return this.plainEndPoint.blockWritable(millisecs);
        }

        public boolean isOpen() {
            if (this.upgraded) {
                return super.isOpen();
            }
            return this.plainEndPoint.isOpen();
        }

        public Object getTransport() {
            if (this.upgraded) {
                return super.getTransport();
            }
            return this.plainEndPoint.getTransport();
        }

        public boolean isBufferingInput() {
            if (this.upgraded) {
                return super.isBufferingInput();
            }
            return this.plainEndPoint.isBufferingInput();
        }

        public boolean isBufferingOutput() {
            if (this.upgraded) {
                return super.isBufferingOutput();
            }
            return this.plainEndPoint.isBufferingOutput();
        }

        public void flush() throws IOException {
            if (this.upgraded) {
                super.flush();
            } else {
                this.plainEndPoint.flush();
            }
        }

        public int getMaxIdleTime() {
            if (this.upgraded) {
                return super.getMaxIdleTime();
            }
            return this.plainEndPoint.getMaxIdleTime();
        }

        public void setMaxIdleTime(int timeMs) throws IOException {
            if (this.upgraded) {
                super.setMaxIdleTime(timeMs);
            } else {
                this.plainEndPoint.setMaxIdleTime(timeMs);
            }
        }
    }

    private class ConnectTimeout
    extends Timeout.Task {
        private final SocketChannel channel;
        private final HttpDestination destination;

        public ConnectTimeout(SocketChannel channel, HttpDestination destination) {
            this.channel = channel;
            this.destination = destination;
        }

        public void expired() {
            if (this.channel.isConnectionPending()) {
                Log.debug((String)"Channel {} timed out while connecting, closing it", (Object)this.channel);
                try {
                    this.channel.close();
                }
                catch (IOException x) {
                    Log.ignore((Throwable)x);
                }
                this.destination.onConnectionFailed(new SocketTimeoutException());
            }
        }
    }

    class Manager
    extends SelectorManager {
        Manager() {
        }

        public boolean dispatch(Runnable task) {
            return ((SelectConnector)SelectConnector.this)._httpClient._threadPool.dispatch(task);
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
        }

        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            if (endpoint instanceof SslSelectChannelEndPoint) {
                return new HttpConnection(SelectConnector.this._sslBuffers, SelectConnector.this._sslBuffers, (EndPoint)endpoint);
            }
            return new HttpConnection(SelectConnector.this._httpClient.getRequestBuffers(), SelectConnector.this._httpClient.getResponseBuffers(), (EndPoint)endpoint);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
            Timeout.Task connectTimeout = (Timeout.Task)SelectConnector.this._connectingChannels.remove(channel);
            if (connectTimeout != null) {
                connectTimeout.cancel();
            }
            Log.debug((String)"Channels with connection pending: {}", (Object)SelectConnector.this._connectingChannels.size());
            HttpDestination dest = (HttpDestination)key.attachment();
            Object ep = null;
            if (dest.isSecure()) {
                SSLEngine engine;
                if (dest.isProxied()) {
                    engine = this.newSslEngine();
                    ep = new ProxySelectChannelEndPoint(channel, selectSet, key, SelectConnector.this._sslBuffers, engine);
                } else {
                    engine = this.newSslEngine();
                    ep = new SslSelectChannelEndPoint(SelectConnector.this._sslBuffers, channel, selectSet, key, engine);
                }
            } else {
                ep = new SelectChannelEndPoint(channel, selectSet, key);
            }
            HttpConnection connection = (HttpConnection)ep.getConnection();
            connection.setDestination(dest);
            dest.onNewConnection(connection);
            return ep;
        }

        private synchronized SSLEngine newSslEngine() throws IOException {
            if (SelectConnector.this._sslContext == null) {
                SelectConnector.this._sslContext = SelectConnector.this._httpClient.getSSLContext();
            }
            SSLEngine sslEngine = SelectConnector.this._sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            sslEngine.beginHandshake();
            return sslEngine;
        }

        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            if (attachment instanceof HttpDestination) {
                ((HttpDestination)attachment).onConnectionFailed(ex);
            } else {
                super.connectionFailed(channel, ex, attachment);
            }
        }
    }
}

