/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.utils.net;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class InetSocketAddresses {
    private InetSocketAddresses() {
    }

    public static InetSocketAddress forUaddrString(String uaddr) {
        int secondPort = uaddr.lastIndexOf(46);
        if (secondPort == -1) {
            throw new IllegalArgumentException("address " + uaddr + " doesn't match rfc5665");
        }
        int firstPort = uaddr.lastIndexOf(46, secondPort - 1);
        if (secondPort == -1) {
            throw new IllegalArgumentException("address " + uaddr + " doesn't match rfc5665");
        }
        InetAddress inetAddr = InetAddresses.forString((String)uaddr.substring(0, firstPort));
        int p1 = Integer.parseInt(uaddr.substring(firstPort + 1, secondPort));
        int p2 = Integer.parseInt(uaddr.substring(secondPort + 1));
        int port = (p1 << 8) + p2;
        return new InetSocketAddress(inetAddr, port);
    }

    public static InetSocketAddress inetAddressOf(String address) {
        int colom = address.indexOf(":");
        if (colom < 0) {
            throw new IllegalArgumentException("invalid host:port format");
        }
        return new InetSocketAddress(address.substring(0, colom), Integer.parseInt(address.substring(colom + 1)));
    }

    public static String uaddrOf(InetSocketAddress socketAddress) {
        int port = socketAddress.getPort();
        int[] port_part = new int[]{(port & 0xFF00) >> 8, port & 0xFF};
        return socketAddress.getAddress().getHostAddress() + "." + port_part[0] + "." + port_part[1];
    }

    public static String uaddrOf(String host, int port) {
        return InetSocketAddresses.uaddrOf(new InetSocketAddress(host, port));
    }
}

