/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dcache.utils.CacheElement;
import org.dcache.utils.CacheEventListener;
import org.dcache.utils.CacheMXBean;
import org.dcache.utils.CacheMXBeanImpl;
import org.dcache.utils.NopCacheEventListener;

public class Cache<K, V>
extends TimerTask {
    private static final Logger _log = Logger.getLogger(Cache.class.getName());
    private final String _name;
    private final long _defaultEntryMaxLifeTime;
    private final long _defaultEntryIdleTime;
    private final int _size;
    private final Map<K, CacheElement<V>> _storage;
    private final Timer _cleaner = new Timer();
    private final Lock _accessLock = new ReentrantLock();
    private final CacheEventListener<K, V> _eventListener;
    private final CacheMXBean<V> _mxBean;
    private final AtomicLong _lastClean = new AtomicLong(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<V> expiredEntries = new ArrayList<V>();
        this._accessLock.lock();
        try {
            long now = System.currentTimeMillis();
            Iterator<Map.Entry<K, CacheElement<V>>> entries = this._storage.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<K, CacheElement<V>> entry = entries.next();
                CacheElement<V> cacheElement = entry.getValue();
                if (cacheElement.validAt(now)) continue;
                _log.log(Level.FINEST, "Cleaning expired entry key = [{0}], value = [{1}]", new Object[]{entry.getKey(), cacheElement.getObject()});
                entries.remove();
                expiredEntries.add(cacheElement.getObject());
            }
            this._lastClean.set(now);
        }
        finally {
            this._accessLock.unlock();
        }
        for (Object v : expiredEntries) {
            this._eventListener.notifyExpired(this, v);
        }
    }

    public Cache(String name, int size, long entryLifeTime, long entryIdleTime) {
        this(name, size, entryLifeTime, entryIdleTime, new NopCacheEventListener(), 30L, TimeUnit.SECONDS);
    }

    public Cache(String name, int size, long entryLifeTime, long entryIdleTime, CacheEventListener<K, V> eventListener, long timeValue, TimeUnit timeUnit) {
        this._name = name;
        this._size = size;
        this._defaultEntryMaxLifeTime = entryLifeTime;
        this._defaultEntryIdleTime = entryIdleTime;
        this._storage = new HashMap<K, CacheElement<V>>(this._size);
        this._eventListener = eventListener;
        this._mxBean = new CacheMXBeanImpl(this);
        this._cleaner.schedule((TimerTask)this, 0L, timeUnit.toMillis(timeValue));
    }

    public String getName() {
        return this._name;
    }

    public void put(K k, V v) {
        this.put(k, v, this._defaultEntryMaxLifeTime, this._defaultEntryIdleTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, V v, long entryMaxLifeTime, long entryIdleTime) {
        _log.log(Level.FINEST, "Adding new cache entry: key = [{0}], value = [{1}]", new Object[]{k, v});
        this._accessLock.lock();
        try {
            if (this._storage.size() >= this._size && !this._storage.containsKey(k)) {
                _log.log(Level.INFO, "Cache limit reached: {0}", this._size);
                throw new MissingResourceException("Cache limit reached", Cache.class.getName(), "");
            }
            this._storage.put(k, new CacheElement<V>(v, entryMaxLifeTime, entryIdleTime));
        }
        finally {
            this._accessLock.unlock();
        }
        this._eventListener.notifyPut(this, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k) {
        V v;
        boolean valid;
        this._accessLock.lock();
        try {
            CacheElement<V> element = this._storage.get(k);
            if (element == null) {
                _log.log(Level.FINEST, "No cache hits for key = [{0}]", k);
                V v2 = null;
                return v2;
            }
            long now = System.currentTimeMillis();
            valid = element.validAt(now);
            v = element.getObject();
            if (!valid) {
                _log.log(Level.FINEST, "Cache hits but entry expired for key = [{0}], value = [{1}]", new Object[]{k, v});
                this._storage.remove(k);
            } else {
                _log.log(Level.FINEST, "Cache hits for key = [{0}], value = [{1}]", new Object[]{k, v});
            }
        }
        finally {
            this._accessLock.unlock();
        }
        if (!valid) {
            this._eventListener.notifyExpired(this, v);
            v = null;
        } else {
            this._eventListener.notifyGet(this, v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K k) {
        V v;
        boolean valid;
        this._accessLock.lock();
        try {
            CacheElement<V> element = this._storage.remove(k);
            if (element == null) {
                boolean bl = false;
                return bl;
            }
            valid = element.validAt(System.currentTimeMillis());
            v = element.getObject();
        }
        finally {
            this._accessLock.unlock();
        }
        _log.log(Level.FINEST, "Removing entry: active = [{0}] key = [{1}], value = [{2}]", new Object[]{valid, k, v});
        this._eventListener.notifyRemove(this, v);
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        this._accessLock.lock();
        try {
            int n = this._storage.size();
            return n;
        }
        finally {
            this._accessLock.unlock();
        }
    }

    public long getEntryIdleTime() {
        return this._defaultEntryIdleTime;
    }

    public long getEntryLiveTime() {
        return this._defaultEntryMaxLifeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        _log.log(Level.FINEST, "Cleaning the cache");
        this._accessLock.lock();
        try {
            this._storage.clear();
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CacheElement<V>> entries() {
        ArrayList<CacheElement<V>> entries;
        this._accessLock.lock();
        try {
            entries = new ArrayList<CacheElement<V>>(this._storage.size());
            for (CacheElement<V> e : this._storage.values()) {
                entries.add(e);
            }
        }
        finally {
            this._accessLock.unlock();
        }
        return entries;
    }

    public long lastClean() {
        return this._lastClean.get();
    }
}

