/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.Serializable;
import org.dcache.util.ChecksumType;

public class Checksum
implements Serializable {
    static final long serialVersionUID = 7338775749513974986L;
    private static final char DELIMITER = ':';
    private static final String[] HEX = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private final ChecksumType type;
    private final String value;

    public Checksum(ChecksumType type, byte[] value) {
        this(type, Checksum.bytesToHexString(value));
    }

    public Checksum(ChecksumType type, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value is not allowed");
        }
        if (type == ChecksumType.ADLER32 && value.length() < 8) {
            char[] newValue = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
            value.getChars(0, value.length(), newValue, newValue.length - value.length());
            value = String.valueOf(newValue);
        }
        this.type = type;
        this.value = value;
    }

    public ChecksumType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getBytes() {
        return Checksum.stringToBytes(this.value);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(Checksum.class)) {
            return false;
        }
        Checksum that = (Checksum)other;
        return this.type == that.type && this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.type.hashCode();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean useStringKey) {
        return (useStringKey ? this.type.getName() : String.valueOf(this.type.getType())) + ":" + this.value;
    }

    private static String byteToHexString(byte b) {
        return HEX[b >> 4 & 0xF] + HEX[b & 0xF];
    }

    public static String bytesToHexString(byte[] value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            sb.append(Checksum.byteToHexString(value[i]));
        }
        return sb.toString();
    }

    private static byte[] stringToBytes(String str) {
        if (str.length() % 2 != 0) {
            str = "0" + str;
        }
        byte[] r = new byte[str.length() / 2];
        int l = str.length();
        for (int i = 0; i < l; i += 2) {
            r[i / 2] = (byte)Integer.parseInt(str.substring(i, i + 2), 16);
        }
        return r;
    }

    public static Checksum parseChecksum(String digest) {
        int del = digest.indexOf(58);
        if (del < 1) {
            throw new IllegalArgumentException("Not a dCache checksum");
        }
        String type = digest.substring(0, del);
        String checksum = digest.substring(del + 1);
        return new Checksum(ChecksumType.getChecksumType(type), checksum);
    }
}

