/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutionTimeGauge {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExecutionTimeGauge.class);
    private final String name;
    private long averageExecutionTime = 0L;
    private long minExecutionTime = 0L;
    private long maxExecutionTime = 0L;
    private long executionTimeRMSS = 0L;
    private int updateNum = 0;
    private long lastExecutionTime = 0L;
    private final long startTime;
    private long periodStartTime;
    private long periodAverageExecutionTime = 0L;
    private long periodUpdateNum = 0L;

    public RequestExecutionTimeGauge(String name) {
        this.name = name;
        this.periodStartTime = this.startTime = System.currentTimeMillis();
    }

    public synchronized void update(long nextExecTime) {
        if (nextExecTime < 0L) {
            LOG.info("possible backwards timeshift detected; discarding invalid data ({})", (Object)nextExecTime);
            return;
        }
        if (this.updateNum == 0) {
            this.averageExecutionTime = nextExecTime;
            this.minExecutionTime = nextExecTime;
            this.maxExecutionTime = nextExecTime;
            this.executionTimeRMSS = nextExecTime * nextExecTime;
        } else {
            this.averageExecutionTime = (this.averageExecutionTime * (long)this.updateNum + nextExecTime) / (long)(this.updateNum + 1);
            this.minExecutionTime = this.getMinExecutionTime() < nextExecTime ? this.getMinExecutionTime() : nextExecTime;
            this.maxExecutionTime = this.getMaxExecutionTime() > nextExecTime ? this.getMaxExecutionTime() : nextExecTime;
            this.executionTimeRMSS = (this.executionTimeRMSS * (long)this.updateNum + nextExecTime * nextExecTime) / (long)(this.updateNum + 1);
        }
        ++this.updateNum;
        this.periodAverageExecutionTime = (this.periodAverageExecutionTime * this.periodUpdateNum + nextExecTime) / (this.periodUpdateNum + 1L);
        ++this.periodUpdateNum;
        this.lastExecutionTime = nextExecTime;
    }

    public synchronized long getAverageExecutionTime() {
        return this.averageExecutionTime;
    }

    public synchronized long getAndResetAverageExecutionTime() {
        long periodAverageExecutionTime = this.periodAverageExecutionTime;
        this.periodUpdateNum = 0L;
        this.periodAverageExecutionTime = this.lastExecutionTime;
        this.periodStartTime = System.currentTimeMillis();
        return periodAverageExecutionTime;
    }

    public synchronized String toString() {
        String aName = this.name;
        if (this.name.length() > 34) {
            aName = aName.substring(0, 34);
        }
        long updatePeriod = System.currentTimeMillis() - this.startTime;
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("%-34s %12d\u00b1%10f %12d %12d %12d %12d %12d", aName, this.averageExecutionTime, this.getStandardError(), this.minExecutionTime, this.maxExecutionTime, this.getStandardDeviation(), this.updateNum, updatePeriod);
        formatter.flush();
        formatter.close();
        return sb.toString();
    }

    public synchronized long getMinExecutionTime() {
        return this.minExecutionTime;
    }

    public synchronized long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public String getName() {
        return this.name;
    }

    public synchronized double getExecutionTimeRMS() {
        return Math.sqrt(this.executionTimeRMSS);
    }

    public synchronized long getStandardDeviation() {
        long deviationSquare = this.executionTimeRMSS - this.averageExecutionTime * this.averageExecutionTime;
        assert (deviationSquare >= 0L);
        return (long)Math.sqrt(this.executionTimeRMSS - this.averageExecutionTime * this.averageExecutionTime);
    }

    public synchronized double getStandardError() {
        return (double)this.getStandardDeviation() / Math.sqrt(this.updateNum);
    }

    public synchronized int getUpdateNum() {
        return this.updateNum;
    }

    public synchronized long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized long getPeriodStartTime() {
        return this.periodStartTime;
    }

    public synchronized long getPeriodAverageExecutionTime() {
        return this.periodAverageExecutionTime;
    }

    public synchronized long getPeriodUpdateNum() {
        return this.periodUpdateNum;
    }
}

