/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.validation;

import org.dcache.gplazma.configuration.parser.FactoryConfigurationException;
import org.dcache.gplazma.validation.FactoryFinder;
import org.dcache.gplazma.validation.ValidationStrategy;

public abstract class ValidationStrategyFactory {
    private static final String DEFAULT_PROPERTY_NAME = "org.dcache.gplazma.validation.ValidationStrategyFactory";
    private static final String DEFAULT_FACTORY = "org.dcache.gplazma.validation.DoorValidationStrategyFactory";

    public static ValidationStrategyFactory getInstance() throws FactoryConfigurationException {
        try {
            return (ValidationStrategyFactory)FactoryFinder.find(DEFAULT_PROPERTY_NAME, DEFAULT_FACTORY);
        }
        catch (ClassNotFoundException cnfe) {
            throw new FactoryConfigurationException("configuration error", cnfe);
        }
        catch (InstantiationException ie) {
            throw new FactoryConfigurationException("configuration error", ie);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryConfigurationException("configuration error", iae);
        }
    }

    public static ValidationStrategyFactory getInstance(String factoryClassName) throws FactoryConfigurationException {
        try {
            return (ValidationStrategyFactory)FactoryFinder.newInstance(factoryClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new FactoryConfigurationException("configuration error", cnfe);
        }
        catch (InstantiationException ie) {
            throw new FactoryConfigurationException("configuration error", ie);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryConfigurationException("configuration error", iae);
        }
    }

    public abstract ValidationStrategy newValidationStrategy();
}

