/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.validation;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.LoginReply;
import org.dcache.gplazma.validation.ValidationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoorValidationStrategy
implements ValidationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoorValidationStrategy.class);

    @Override
    public void validate(LoginReply loginReply) throws AuthenticationException {
        LOGGER.debug("Validating loginReply {}", (Object)loginReply);
        if (loginReply == null) {
            throw new NullPointerException("loginReply is null");
        }
        Set<Principal> principals = DoorValidationStrategy.getPrincipalsFromLoginReply(loginReply);
        DoorValidationStrategy.validatePrincipals(principals);
        Set<Object> attributes = DoorValidationStrategy.getSessionAttributesFromLoginReply(loginReply);
        DoorValidationStrategy.validateAttributes(attributes);
    }

    private static void validatePrincipals(Set<Principal> principals) throws AuthenticationException {
        boolean userNamePrincipalFound = false;
        boolean uidPrincipalFound = false;
        boolean primaryGidPrincipalFound = false;
        for (Principal principal : principals) {
            GidPrincipal gidPrincipal;
            if (principal instanceof UserNamePrincipal) {
                if (userNamePrincipalFound) {
                    throw new AuthenticationException("multiple usernames");
                }
                userNamePrincipalFound = true;
                continue;
            }
            if (principal instanceof UidPrincipal) {
                if (uidPrincipalFound) {
                    throw new AuthenticationException("multiple UIDs");
                }
                uidPrincipalFound = true;
                continue;
            }
            if (!(principal instanceof GidPrincipal) || !(gidPrincipal = (GidPrincipal)principal).isPrimaryGroup()) continue;
            if (primaryGidPrincipalFound) {
                throw new AuthenticationException("multiple GIDs");
            }
            primaryGidPrincipalFound = true;
        }
        if (userNamePrincipalFound && uidPrincipalFound && primaryGidPrincipalFound) {
            return;
        }
        StringBuilder errorMsg = new StringBuilder();
        if (!userNamePrincipalFound) {
            errorMsg.append("no username");
        }
        if (!uidPrincipalFound) {
            DoorValidationStrategy.appendWithComma(errorMsg, "no UID");
        }
        if (!primaryGidPrincipalFound) {
            DoorValidationStrategy.appendWithComma(errorMsg, "no primary GID");
        }
        throw new AuthenticationException(errorMsg.toString());
    }

    private static void validateAttributes(Set<Object> attributes) throws AuthenticationException {
        boolean homeDirectoryFound = false;
        boolean rootDirectoryFound = false;
        boolean readOnlyFound = false;
        for (Object attribute : attributes) {
            if (attribute instanceof HomeDirectory) {
                if (homeDirectoryFound) {
                    throw new AuthenticationException("multiple home-directories");
                }
                homeDirectoryFound = true;
            }
            if (attribute instanceof RootDirectory) {
                if (rootDirectoryFound) {
                    throw new AuthenticationException("multiple root-directories");
                }
                rootDirectoryFound = true;
            }
            if (!(attribute instanceof ReadOnly)) continue;
            if (readOnlyFound) {
                throw new AuthenticationException("multiple read-only declarations");
            }
            readOnlyFound = true;
        }
        if (homeDirectoryFound && rootDirectoryFound && readOnlyFound) {
            return;
        }
        StringBuilder errorMsg = new StringBuilder();
        if (!homeDirectoryFound) {
            errorMsg.append("no home-directory");
        }
        if (!rootDirectoryFound) {
            DoorValidationStrategy.appendWithComma(errorMsg, "no root-directory");
        }
        if (!readOnlyFound) {
            DoorValidationStrategy.appendWithComma(errorMsg, "no read-only declaration");
        }
        throw new AuthenticationException(errorMsg.toString());
    }

    private static StringBuilder appendWithComma(StringBuilder sb, String message) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        return sb.append(message);
    }

    private static Set<Object> getSessionAttributesFromLoginReply(LoginReply loginReply) throws AuthenticationException {
        Set<Object> attributes = loginReply.getSessionAttributes();
        if (attributes == null) {
            throw new AuthenticationException("attributes is null");
        }
        return attributes;
    }

    private static Set<Principal> getPrincipalsFromLoginReply(LoginReply loginReply) throws AuthenticationException {
        Subject subject = loginReply.getSubject();
        if (subject == null) {
            throw new AuthenticationException("subject is null");
        }
        Set<Principal> principals = subject.getPrincipals();
        if (principals == null) {
            throw new AuthenticationException("subject principals is null");
        }
        return principals;
    }
}

