/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.util;

import java.io.File;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.dcache.gplazma.AuthenticationException;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIVerifier;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;
import org.glite.voms.ac.VOMSTrustStore;
import org.globus.gsi.CertUtil;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSException;
import org.slf4j.MDC;

public class CertificateUtils {
    static final String SYS_VOMSDIR = "VOMSDIR";
    static final String SYS_CADIR = "CADIR";
    static final String CAPNULL = "/Capability=NULL";
    static final String ROLENULL = "/Role=NULL";
    private static PKIVerifier pkiVerifier;

    public static Collection<String> getFQANsFromGSSContext(ExtendedGSSContext gssContext) throws AuthorizationException {
        X509Certificate[] chain;
        try {
            chain = (X509Certificate[])gssContext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
        }
        catch (GSSException gsse) {
            throw new AuthorizationException("Could not extract certificate chain from context " + gsse.getMessage() + "\n" + gsse.getCause());
        }
        try {
            VOMSValidator validator = new VOMSValidator(null, new ACValidator(CertificateUtils.getPkiVerifier(null, null, MDC.getCopyOfContextMap())));
            validator.setClientChain(chain).parse();
            return new ArrayList<String>(Arrays.asList(validator.getAllFullyQualifiedAttributes()));
        }
        catch (AuthorizationException ae) {
            throw new AuthorizationException(ae.toString());
        }
        catch (Exception e) {
            throw new AuthorizationException("Could not validate role.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PKIVerifier getPkiVerifier(String vomsDir, String caDir, Map<?, ?> mdcContext) throws IOException, CertificateException, CRLException {
        if (pkiVerifier == null) {
            Map map = MDC.getCopyOfContextMap();
            try {
                if (mdcContext != null) {
                    MDC.setContextMap(mdcContext);
                }
                if (vomsDir == null) {
                    vomsDir = System.getProperty(SYS_VOMSDIR);
                }
                if (vomsDir == null) {
                    vomsDir = PKIStore.DEFAULT_VOMSDIR;
                }
                PKIStore vomsStore = null;
                File actualDir = new File(vomsDir);
                if (actualDir.exists() && actualDir.isDirectory() && actualDir.list().length > 0) {
                    vomsStore = new PKIStore(vomsDir, 1);
                }
                if (caDir == null) {
                    caDir = System.getProperty(SYS_CADIR);
                }
                if (caDir == null) {
                    caDir = PKIStore.DEFAULT_CADIR;
                }
                PKIStore caStore = null;
                actualDir = new File(caDir);
                if (actualDir.exists() && actualDir.isDirectory() && actualDir.list().length > 0) {
                    caStore = new PKIStore(caDir, 2);
                }
                pkiVerifier = new PKIVerifier((VOMSTrustStore)vomsStore, caStore);
            }
            finally {
                if (map != null) {
                    MDC.setContextMap((Map)map);
                }
            }
        }
        return pkiVerifier;
    }

    public static String getSubjectFromX509Chain(X509Certificate[] chain, boolean omitEmail) throws AuthenticationException {
        String subjectDN = null;
        TBSCertificateStructure tbsCert = null;
        X509Certificate clientcert = null;
        try {
            for (X509Certificate testcert : chain) {
                tbsCert = BouncyCastleUtil.getTBSCertificateStructure((X509Certificate)testcert);
                int certType = BouncyCastleUtil.getCertificateType((TBSCertificateStructure)tbsCert);
                if (CertUtil.isImpersonationProxy((int)certType)) continue;
                clientcert = testcert;
                break;
            }
        }
        catch (IOException e) {
            throw new AuthenticationException(e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new AuthenticationException(e.getMessage(), e);
        }
        if (clientcert == null) {
            throw new AuthenticationException("could not find client certificate");
        }
        if (tbsCert != null) {
            subjectDN = CertificateUtils.toGlobusString((ASN1Sequence)tbsCert.getSubject().getDERObject(), omitEmail);
        }
        return subjectDN;
    }

    public static String getSubjectX509Issuer(X509Certificate[] chain, boolean skipImpersonation) throws AuthenticationException {
        if (chain == null) {
            return null;
        }
        X509Certificate clientcert = null;
        for (X509Certificate testcert : chain) {
            try {
                if (!skipImpersonation) {
                    clientcert = testcert;
                    break;
                }
                TBSCertificateStructure tbsCert = BouncyCastleUtil.getTBSCertificateStructure((X509Certificate)testcert);
                int certType = BouncyCastleUtil.getCertificateType((TBSCertificateStructure)tbsCert);
                if (CertUtil.isImpersonationProxy((int)certType)) continue;
                clientcert = testcert;
                break;
            }
            catch (CertificateEncodingException t) {
                throw new AuthenticationException("badly formatted certificate: " + t.getMessage(), t);
            }
            catch (IOException t) {
                throw new AuthenticationException("cannot read certificate: " + t.getMessage(), t);
            }
            catch (CertificateException t) {
                throw new AuthenticationException("problem with certificate: " + t.getMessage(), t);
            }
        }
        if (clientcert == null) {
            throw new AuthenticationException("no client certificate");
        }
        return CertificateUtils.toGlobusDN(((Object)clientcert.getIssuerDN()).toString(), skipImpersonation);
    }

    public static String toGlobusDN(String certDN, boolean invert) {
        StringTokenizer tokens = new StringTokenizer(certDN, ",");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (invert) {
                buf.insert(0, token);
                buf.insert(0, "/");
                continue;
            }
            buf.append("/");
            buf.append(token);
        }
        return buf.toString();
    }

    public static String toGlobusString(ASN1Sequence seq, boolean omitEmail) {
        if (seq == null) {
            return null;
        }
        Enumeration e = seq.getObjects();
        StringBuffer buf = new StringBuffer();
        while (e.hasMoreElements()) {
            ASN1Set set = (ASN1Set)e.nextElement();
            Enumeration ee = set.getObjects();
            boolean didappend = false;
            while (ee.hasMoreElements()) {
                ASN1Sequence s = (ASN1Sequence)ee.nextElement();
                DERObjectIdentifier oid = (DERObjectIdentifier)s.getObjectAt(0);
                String sym = (String)X509Name.DefaultSymbols.get(oid);
                if (oid.equals((Object)X509Name.EmailAddress) && omitEmail) continue;
                if (!didappend) {
                    buf.append('/');
                    didappend = true;
                }
                if (sym == null) {
                    buf.append(oid.getId());
                } else {
                    buf.append(sym);
                }
                buf.append('=');
                buf.append(((DERString)s.getObjectAt(1)).getString());
                if (!ee.hasMoreElements()) continue;
                buf.append('+');
            }
        }
        return buf.toString();
    }
}

