/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.strategies;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.monitor.LoginMonitor;
import org.dcache.gplazma.plugins.GPlazmaAccountPlugin;
import org.dcache.gplazma.strategies.AccountStrategy;
import org.dcache.gplazma.strategies.GPlazmaPluginElement;
import org.dcache.gplazma.strategies.PAMStyleStrategy;
import org.dcache.gplazma.strategies.PluginCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccountStrategy
implements AccountStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAccountStrategy.class);
    private PAMStyleStrategy<GPlazmaAccountPlugin> pamStyleAccountStrategy;

    @Override
    public void setPlugins(List<GPlazmaPluginElement<GPlazmaAccountPlugin>> plugins) {
        this.pamStyleAccountStrategy = new PAMStyleStrategy(plugins);
    }

    @Override
    public synchronized void account(final LoginMonitor monitor, final Set<Principal> authorizedPrincipals) throws AuthenticationException {
        this.pamStyleAccountStrategy.callPlugins(new PluginCaller<GPlazmaAccountPlugin>(){

            @Override
            public void call(GPlazmaPluginElement<GPlazmaAccountPlugin> pe) throws AuthenticationException {
                monitor.accountPluginBegins(pe.getName(), pe.getControl(), authorizedPrincipals);
                GPlazmaAccountPlugin plugin = pe.getPlugin();
                LoginMonitor.Result result = LoginMonitor.Result.FAIL;
                String error = null;
                try {
                    plugin.account(authorizedPrincipals);
                    result = LoginMonitor.Result.SUCCESS;
                }
                catch (AuthenticationException e) {
                    error = e.getMessage();
                    throw e;
                }
                finally {
                    monitor.accountPluginEnds(pe.getName(), pe.getControl(), result, error, authorizedPrincipals);
                }
            }
        });
    }
}

