/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.monitor;

import java.security.Principal;
import java.util.Set;
import org.dcache.gplazma.configuration.ConfigurationItemControl;
import org.dcache.gplazma.monitor.LoginMonitor;

public class CombinedLoginMonitor
implements LoginMonitor {
    private final LoginMonitor[] _inner;

    public static LoginMonitor of(LoginMonitor ... monitors) {
        return new CombinedLoginMonitor(monitors);
    }

    public CombinedLoginMonitor(LoginMonitor ... monitors) {
        this._inner = monitors;
    }

    @Override
    public void authBegins(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> principals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.authBegins(publicCredentials, privateCredentials, principals);
        }
    }

    @Override
    public void authPluginBegins(String name, ConfigurationItemControl control, Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> principals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.authPluginBegins(name, control, publicCredentials, privateCredentials, principals);
        }
    }

    @Override
    public void authPluginEnds(String name, ConfigurationItemControl control, LoginMonitor.Result result, String error, Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> principals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.authPluginEnds(name, control, result, error, publicCredentials, privateCredentials, principals);
        }
    }

    @Override
    public void authEnds(Set<Principal> principals, LoginMonitor.Result result) {
        for (LoginMonitor monitor : this._inner) {
            monitor.authEnds(principals, result);
        }
    }

    @Override
    public void mapBegins(Set<Principal> principals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.mapBegins(principals);
        }
    }

    @Override
    public void mapPluginBegins(String name, ConfigurationItemControl control, Set<Principal> principals, Set<Principal> authorizedPrincipals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.mapPluginBegins(name, control, principals, authorizedPrincipals);
        }
    }

    @Override
    public void mapPluginEnds(String name, ConfigurationItemControl control, LoginMonitor.Result result, String error, Set<Principal> principals, Set<Principal> authorizedPrincipals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.mapPluginEnds(name, control, result, error, principals, authorizedPrincipals);
        }
    }

    @Override
    public void mapEnds(Set<Principal> principals, LoginMonitor.Result result) {
        for (LoginMonitor monitor : this._inner) {
            monitor.mapEnds(principals, result);
        }
    }

    @Override
    public void accountBegins(Set<Principal> principals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.accountBegins(principals);
        }
    }

    @Override
    public void accountPluginBegins(String name, ConfigurationItemControl control, Set<Principal> principals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.accountPluginBegins(name, control, principals);
        }
    }

    @Override
    public void accountPluginEnds(String name, ConfigurationItemControl control, LoginMonitor.Result result, String error, Set<Principal> principals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.accountPluginEnds(name, control, result, error, principals);
        }
    }

    @Override
    public void accountEnds(Set<Principal> principals, LoginMonitor.Result result) {
        for (LoginMonitor monitor : this._inner) {
            monitor.accountEnds(principals, result);
        }
    }

    @Override
    public void sessionBegins(Set<Principal> principals) {
        for (LoginMonitor monitor : this._inner) {
            monitor.sessionBegins(principals);
        }
    }

    @Override
    public void sessionPluginBegins(String name, ConfigurationItemControl control, Set<Principal> principals, Set<Object> attributes) {
        for (LoginMonitor monitor : this._inner) {
            monitor.sessionPluginBegins(name, control, principals, attributes);
        }
    }

    @Override
    public void sessionPluginEnds(String name, ConfigurationItemControl control, LoginMonitor.Result result, String error, Set<Principal> principals, Set<Object> attributes) {
        for (LoginMonitor monitor : this._inner) {
            monitor.sessionPluginEnds(name, control, result, error, principals, attributes);
        }
    }

    @Override
    public void sessionEnds(Set<Principal> principals, Set<Object> attributes, LoginMonitor.Result result) {
        for (LoginMonitor monitor : this._inner) {
            monitor.sessionEnds(principals, attributes, result);
        }
    }

    @Override
    public void validationResult(LoginMonitor.Result result, String error) {
        for (LoginMonitor monitor : this._inner) {
            monitor.validationResult(result, error);
        }
    }
}

