/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.gplazma.loader.PluginLoadingException;
import org.dcache.gplazma.loader.PluginMetadata;

public class PluginRepository {
    private final Set<PluginMetadata> _plugins = new HashSet<PluginMetadata>();
    private final Map<String, PluginMetadata> _pluginByName = new HashMap<String, PluginMetadata>();

    public void addPlugin(PluginMetadata metadata) {
        this._plugins.add(metadata);
        for (String name : metadata.getPluginNames()) {
            this._pluginByName.put(name, metadata);
        }
    }

    public boolean hasPluginWithName(String name) {
        return this._pluginByName.containsKey(name);
    }

    public PluginMetadata getPlugin(String name) throws PluginLoadingException {
        PluginMetadata metadata = this._pluginByName.get(name);
        if (metadata == null) {
            throw new PluginLoadingException("no such plugin");
        }
        return metadata;
    }

    public void processPluginsWith(PluginMetadataProcessor processor) {
        for (PluginMetadata plugin : this._plugins) {
            processor.process(plugin);
        }
    }

    public int size() {
        return this._plugins.size();
    }

    public static interface PluginMetadataProcessor {
        public void process(PluginMetadata var1);
    }
}

