/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.configuration.parser;

import com.google.common.base.Preconditions;
import org.dcache.gplazma.GPlazmaInternalException;

public class ParseException
extends GPlazmaInternalException {
    static final long serialVersionUID = 8146460786081822785L;
    private int offset = -1;

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, Throwable cause) {
        super(message, cause);
    }

    public ParseException(String message, int offset) {
        super(message);
        this.offset = offset;
    }

    public ParseException(String message, Throwable cause, int offset) {
        super(message, cause);
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"invalid offset: %s", (Object[])new Object[]{offset});
        this.offset = offset;
    }

    @Override
    public String getMessage() {
        String s = super.getMessage();
        if (this.offset == -1) {
            return s;
        }
        return s + " [offset=" + this.offset + "]";
    }
}

