/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.security.auth.Subject;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.Origin;
import org.dcache.auth.PasswordCredential;
import org.dcache.commons.util.NDC;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.GPlazmaInternalException;
import org.dcache.gplazma.LoginReply;
import org.dcache.gplazma.NoSuchPrincipalException;
import org.dcache.gplazma.configuration.Configuration;
import org.dcache.gplazma.configuration.ConfigurationItem;
import org.dcache.gplazma.configuration.ConfigurationItemControl;
import org.dcache.gplazma.configuration.ConfigurationItemType;
import org.dcache.gplazma.configuration.ConfigurationLoadingStrategy;
import org.dcache.gplazma.configuration.parser.FactoryConfigurationException;
import org.dcache.gplazma.loader.CachingPluginLoaderDecorator;
import org.dcache.gplazma.loader.PluginLoader;
import org.dcache.gplazma.loader.PluginLoadingException;
import org.dcache.gplazma.loader.XmlResourcePluginLoader;
import org.dcache.gplazma.monitor.CombinedLoginMonitor;
import org.dcache.gplazma.monitor.LoggingLoginMonitor;
import org.dcache.gplazma.monitor.LoginMonitor;
import org.dcache.gplazma.monitor.LoginResult;
import org.dcache.gplazma.monitor.LoginResultPrinter;
import org.dcache.gplazma.monitor.RecordingLoginMonitor;
import org.dcache.gplazma.plugins.GPlazmaAccountPlugin;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.plugins.GPlazmaIdentityPlugin;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.GPlazmaPlugin;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;
import org.dcache.gplazma.strategies.AccountStrategy;
import org.dcache.gplazma.strategies.AuthenticationStrategy;
import org.dcache.gplazma.strategies.GPlazmaPluginElement;
import org.dcache.gplazma.strategies.IdentityStrategy;
import org.dcache.gplazma.strategies.MappingStrategy;
import org.dcache.gplazma.strategies.SessionStrategy;
import org.dcache.gplazma.strategies.StrategyFactory;
import org.dcache.gplazma.validation.ValidationStrategy;
import org.dcache.gplazma.validation.ValidationStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPlazma {
    private static final Logger LOGGER = LoggerFactory.getLogger(GPlazma.class);
    private static final LoginMonitor LOGGING_LOGIN_MONITOR = new LoggingLoginMonitor();
    private KnownFailedLogins _failedLogins = new KnownFailedLogins();
    private Properties _globalProperties;
    private boolean _globalPropertiesHaveUpdated = false;
    private PluginLoader pluginLoader;
    private GPlazmaInternalException _lastLoadPluginsProblem;
    private List<GPlazmaPluginElement<GPlazmaAuthenticationPlugin>> authenticationPluginElements;
    private List<GPlazmaPluginElement<GPlazmaMappingPlugin>> mappingPluginElements;
    private List<GPlazmaPluginElement<GPlazmaAccountPlugin>> accountPluginElements;
    private List<GPlazmaPluginElement<GPlazmaSessionPlugin>> sessionPluginElements;
    private List<GPlazmaPluginElement<GPlazmaIdentityPlugin>> identityPluginElements;
    private final ConfigurationLoadingStrategy configurationLoadingStrategy;
    private AuthenticationStrategy _authStrategy;
    private MappingStrategy _mapStrategy;
    private AccountStrategy _accountStrategy;
    private SessionStrategy _sessionStrategy;
    private ValidationStrategy validationStrategy;
    private IdentityStrategy identityStrategy;

    public GPlazma(ConfigurationLoadingStrategy configurationLoadingStrategy, Properties properties) {
        this.configurationLoadingStrategy = configurationLoadingStrategy;
        this._globalProperties = properties;
        try {
            this.loadPlugins();
        }
        catch (GPlazmaInternalException gPlazmaInternalException) {
            // empty catch block
        }
    }

    public LoginReply login(Subject subject) throws AuthenticationException {
        RecordingLoginMonitor record = new RecordingLoginMonitor();
        LoginMonitor combined = CombinedLoginMonitor.of(record, LOGGING_LOGIN_MONITOR);
        try {
            LoginReply reply = this.login(subject, combined);
            this._failedLogins.remove(subject);
            return reply;
        }
        catch (AuthenticationException e) {
            if (!this._failedLogins.has(subject)) {
                this._failedLogins.add(subject);
                LoginResult result = record.getResult();
                LoginResultPrinter printer = new LoginResultPrinter(result);
                LOGGER.warn("Login attempt failed; explaination follows:\n" + printer.print());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginReply login(Subject subject, LoginMonitor monitor) throws AuthenticationException {
        SessionStrategy sessionStrategy;
        AccountStrategy accountStrategy;
        MappingStrategy mapStrategy;
        AuthenticationStrategy authStrategy;
        Preconditions.checkNotNull((Object)subject, (Object)"subject is null");
        ConfigurationLoadingStrategy configurationLoadingStrategy = this.configurationLoadingStrategy;
        synchronized (configurationLoadingStrategy) {
            try {
                this.checkPluginConfig();
            }
            catch (GPlazmaInternalException e) {
                throw new AuthenticationException("internal gPlazma error: " + e.getMessage());
            }
            authStrategy = this._authStrategy;
            mapStrategy = this._mapStrategy;
            accountStrategy = this._accountStrategy;
            sessionStrategy = this._sessionStrategy;
        }
        Set<Principal> identifiedPrincipals = this.doAuthPhase(authStrategy, monitor, subject);
        Set<Principal> authorizedPrincipals = this.doMapPhase(mapStrategy, monitor, identifiedPrincipals);
        this.doAccountPhase(accountStrategy, monitor, authorizedPrincipals);
        Set<Object> attributes = this.doSessionPhase(sessionStrategy, monitor, authorizedPrincipals);
        return this.buildReply(monitor, subject, authorizedPrincipals, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Principal> doAuthPhase(AuthenticationStrategy strategy, LoginMonitor monitor, Subject subject) throws AuthenticationException {
        Set<Object> publicCredentials = subject.getPublicCredentials();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.addAll(subject.getPrincipals());
        NDC.push((String)"AUTH");
        LoginMonitor.Result result = LoginMonitor.Result.FAIL;
        try {
            monitor.authBegins(publicCredentials, privateCredentials, principals);
            strategy.authenticate(monitor, publicCredentials, privateCredentials, principals);
            result = LoginMonitor.Result.SUCCESS;
        }
        finally {
            NDC.pop();
            monitor.authEnds(principals, result);
        }
        return principals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Principal> doMapPhase(MappingStrategy strategy, LoginMonitor monitor, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        HashSet<Principal> authorizedPrincipals = new HashSet<Principal>();
        NDC.push((String)"MAP");
        LoginMonitor.Result result = LoginMonitor.Result.FAIL;
        try {
            monitor.mapBegins(identifiedPrincipals);
            strategy.map(monitor, identifiedPrincipals, authorizedPrincipals);
            result = LoginMonitor.Result.SUCCESS;
        }
        finally {
            NDC.pop();
            monitor.mapEnds(authorizedPrincipals, result);
        }
        return authorizedPrincipals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAccountPhase(AccountStrategy strategy, LoginMonitor monitor, Set<Principal> principals) throws AuthenticationException {
        NDC.push((String)"ACCOUNT");
        LoginMonitor.Result result = LoginMonitor.Result.FAIL;
        try {
            monitor.accountBegins(principals);
            strategy.account(monitor, principals);
            result = LoginMonitor.Result.SUCCESS;
        }
        finally {
            NDC.pop();
            monitor.accountEnds(principals, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Object> doSessionPhase(SessionStrategy strategy, LoginMonitor monitor, Set<Principal> principals) throws AuthenticationException {
        HashSet<Object> attributes = new HashSet<Object>();
        NDC.push((String)"SESSION");
        LoginMonitor.Result result = LoginMonitor.Result.FAIL;
        try {
            monitor.sessionBegins(principals);
            strategy.session(monitor, principals, attributes);
            result = LoginMonitor.Result.SUCCESS;
        }
        finally {
            NDC.pop();
            monitor.sessionEnds(principals, attributes, result);
        }
        return attributes;
    }

    public LoginReply buildReply(LoginMonitor monitor, Subject originalSubject, Set<Principal> principals, Set<Object> attributes) throws AuthenticationException {
        Set<Object> publicCredentials = originalSubject.getPublicCredentials();
        Set<Object> privateCredentials = originalSubject.getPrivateCredentials();
        LoginReply reply = new LoginReply();
        Subject subject = new Subject(false, principals, publicCredentials, privateCredentials);
        reply.setSubject(subject);
        reply.setSessionAttributes(attributes);
        LoginMonitor.Result result = LoginMonitor.Result.FAIL;
        String error = null;
        NDC.push((String)"VALIDATION");
        try {
            this.validationStrategy.validate(reply);
            result = LoginMonitor.Result.SUCCESS;
        }
        catch (AuthenticationException e) {
            error = e.getMessage();
            throw e;
        }
        finally {
            NDC.pop();
            monitor.validationResult(result, error);
        }
        return reply;
    }

    public Principal map(Principal principal) throws NoSuchPrincipalException {
        try {
            return this.getIdentityStrategy().map(principal);
        }
        catch (GPlazmaInternalException e) {
            throw new NoSuchPrincipalException("internal gPlazma error: " + e.getMessage());
        }
    }

    public Set<Principal> reverseMap(Principal principal) throws NoSuchPrincipalException {
        try {
            return this.getIdentityStrategy().reverseMap(principal);
        }
        catch (GPlazmaInternalException e) {
            throw new NoSuchPrincipalException("internal gPlazma error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdentityStrategy getIdentityStrategy() throws GPlazmaInternalException {
        ConfigurationLoadingStrategy configurationLoadingStrategy = this.configurationLoadingStrategy;
        synchronized (configurationLoadingStrategy) {
            this.checkPluginConfig();
            return this.identityStrategy;
        }
    }

    private void loadPlugins() throws GPlazmaInternalException {
        LOGGER.debug("reloading plugins");
        this.pluginLoader = new CachingPluginLoaderDecorator(XmlResourcePluginLoader.newPluginLoader());
        this.pluginLoader.init();
        this.resetPlugins();
        try {
            Configuration configuration = this.configurationLoadingStrategy.load();
            List<ConfigurationItem> items = configuration.getConfigurationItemList();
            for (ConfigurationItem item : items) {
                GPlazmaPlugin plugin;
                String pluginName = item.getPluginName();
                Properties pluginProperties = item.getPluginConfiguration();
                Properties combinedProperties = new Properties(this._globalProperties);
                combinedProperties.putAll((Map<?, ?>)pluginProperties);
                try {
                    plugin = this.pluginLoader.newPluginByName(pluginName, combinedProperties);
                }
                catch (PluginLoadingException e) {
                    throw new PluginLoadingException("failed to create " + pluginName + ": " + e.getMessage(), e);
                }
                ConfigurationItemControl control = item.getControl();
                ConfigurationItemType type = item.getType();
                this.classifyPlugin(type, plugin, pluginName, control);
            }
            this.initStrategies();
        }
        catch (GPlazmaInternalException e) {
            LOGGER.error(e.getMessage());
            this._lastLoadPluginsProblem = e;
            throw e;
        }
        if (this.isPreviousLoadPluginsProblematic()) {
            LOGGER.warn("gPlazma configuration successfully loaded");
            this._lastLoadPluginsProblem = null;
        }
    }

    private void resetPlugins() {
        this.authenticationPluginElements = new ArrayList<GPlazmaPluginElement<GPlazmaAuthenticationPlugin>>();
        this.mappingPluginElements = new ArrayList<GPlazmaPluginElement<GPlazmaMappingPlugin>>();
        this.accountPluginElements = new ArrayList<GPlazmaPluginElement<GPlazmaAccountPlugin>>();
        this.sessionPluginElements = new ArrayList<GPlazmaPluginElement<GPlazmaSessionPlugin>>();
        this.identityPluginElements = new ArrayList<GPlazmaPluginElement<GPlazmaIdentityPlugin>>();
    }

    private void initStrategies() throws FactoryConfigurationException {
        StrategyFactory factory = StrategyFactory.getInstance();
        this._authStrategy = factory.newAuthenticationStrategy();
        this._authStrategy.setPlugins(this.authenticationPluginElements);
        this._mapStrategy = factory.newMappingStrategy();
        this._mapStrategy.setPlugins(this.mappingPluginElements);
        this._accountStrategy = factory.newAccountStrategy();
        this._accountStrategy.setPlugins(this.accountPluginElements);
        this._sessionStrategy = factory.newSessionStrategy();
        this._sessionStrategy.setPlugins(this.sessionPluginElements);
        this.identityStrategy = factory.newIdentityStrategy();
        this.identityStrategy.setPlugins(this.identityPluginElements);
        ValidationStrategyFactory validationFactory = ValidationStrategyFactory.getInstance();
        this.validationStrategy = validationFactory.newValidationStrategy();
    }

    private void checkPluginConfig() throws GPlazmaInternalException {
        if (this._globalPropertiesHaveUpdated || this.configurationLoadingStrategy.hasUpdated()) {
            this._globalPropertiesHaveUpdated = false;
            this._failedLogins.clear();
            this.loadPlugins();
        }
        if (this.isPreviousLoadPluginsProblematic()) {
            throw this._lastLoadPluginsProblem;
        }
    }

    private boolean isPreviousLoadPluginsProblematic() {
        return this._lastLoadPluginsProblem != null;
    }

    private void classifyPlugin(ConfigurationItemType type, GPlazmaPlugin plugin, String pluginName, ConfigurationItemControl control) throws PluginLoadingException {
        if (!type.getType().isAssignableFrom(plugin.getClass())) {
            throw new PluginLoadingException("plugin " + pluginName + " (java class  " + plugin.getClass().getCanonicalName() + ") does not support being loaded as type " + (Object)((Object)type));
        }
        switch (type) {
            case AUTHENTICATION: {
                GPlazma.storePluginElement(plugin, pluginName, control, this.authenticationPluginElements);
                break;
            }
            case MAPPING: {
                GPlazma.storePluginElement(plugin, pluginName, control, this.mappingPluginElements);
                break;
            }
            case ACCOUNT: {
                GPlazma.storePluginElement(plugin, pluginName, control, this.accountPluginElements);
                break;
            }
            case SESSION: {
                GPlazma.storePluginElement(plugin, pluginName, control, this.sessionPluginElements);
                break;
            }
            case IDENTITY: {
                GPlazma.storePluginElement(plugin, pluginName, control, this.identityPluginElements);
                break;
            }
            default: {
                throw new PluginLoadingException("unknown plugin type " + (Object)((Object)type));
            }
        }
    }

    private static <T extends GPlazmaPlugin> void storePluginElement(GPlazmaPlugin plugin, String pluginName, ConfigurationItemControl control, List<GPlazmaPluginElement<T>> pluginElements) throws PluginLoadingException {
        GPlazmaPlugin authPlugin = plugin;
        GPlazmaPluginElement<GPlazmaPlugin> pluginElement = new GPlazmaPluginElement<GPlazmaPlugin>(authPlugin, pluginName, control);
        pluginElements.add(pluginElement);
    }

    private static class KnownFailedLogins {
        private final Set<Subject> _failedLogins = new CopyOnWriteArraySet<Subject>();

        private KnownFailedLogins() {
        }

        private static void addPrincipalsForPrivateCredentials(Set<Principal> principals, Set<Object> privateCredentials) {
            PasswordCredential password = (PasswordCredential)Iterables.getFirst((Iterable)Iterables.filter(privateCredentials, PasswordCredential.class), null);
            if (password != null) {
                LoginNamePrincipal loginName = new LoginNamePrincipal(password.getUsername());
                principals.add((Principal)loginName);
            }
        }

        private static void addNormalisedPublicCredentials(Set<Object> storageCredentials, Set<Object> credentials) {
            for (Object credential : credentials) {
                Object normalised = credential instanceof X509Certificate[] ? KnownFailedLogins.normalise((X509Certificate[])credential) : credential;
                storageCredentials.add(normalised);
            }
        }

        private static Object normalise(X509Certificate[] credential) {
            return Lists.newArrayList((Object[])credential);
        }

        private static Subject storageSubjectFor(Subject subject) {
            Subject storage = new Subject();
            KnownFailedLogins.addNormalisedPublicCredentials(storage.getPublicCredentials(), subject.getPublicCredentials());
            Collection allExceptOrigin = Collections2.filter(subject.getPrincipals(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Origin.class)));
            storage.getPrincipals().addAll(allExceptOrigin);
            KnownFailedLogins.addPrincipalsForPrivateCredentials(storage.getPrincipals(), subject.getPrivateCredentials());
            return storage;
        }

        private boolean has(Subject subject) {
            Subject storage = KnownFailedLogins.storageSubjectFor(subject);
            return this._failedLogins.contains(storage);
        }

        private void add(Subject subject) {
            Subject storage = KnownFailedLogins.storageSubjectFor(subject);
            this._failedLogins.add(storage);
        }

        private void remove(Subject subject) {
            Subject storage = KnownFailedLogins.storageSubjectFor(subject);
            this._failedLogins.remove(storage);
        }

        private void clear() {
            this._failedLogins.clear();
        }
    }
}

