/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.util.Random;

public class TestHistogramFitting
extends AidaTestCase {
    IAnalysisFactory analysisFactory = null;
    ITreeFactory treeFactory = null;
    ITree tree = null;
    IHistogramFactory histogramFactory = null;
    IFunctionFactory functionFactory = null;
    String newName = null;
    IHistogram1D h = null;
    IFunction f = null;
    IFunction ff = null;
    boolean debug = true;
    int nEntries = 0;
    int xBins = 0;
    int nRep = 0;
    double xmin = 0.0;
    double xmax = 0.0;
    double ymin = 0.0;
    double ymax = 0.0;
    double[] a = null;
    Random r = null;

    public TestHistogramFitting(String testName) {
        super(testName);
    }

    public void testTestFitting1D() {
        this.r = this.getRandomNumberGenerator();
        this.init();
        this.a = new double[2];
        this.a[0] = 1.2;
        this.a[1] = 5.5;
        this.nRep = 1000;
        this.newName = "Exponential: amplitude=" + this.a[0] + ",  exponent=" + this.a[1];
        this.h = this.histogramFactory.createHistogram1D("Exponent", this.xBins, this.xmin, this.xmax);
        this.ff = this.functionFactory.createFunctionByName("Exp.1", "E");
        this.fillff();
        this.checkFitting1Dff(this.newName);
        this.a = new double[5];
        this.a[4] = -0.3;
        this.a[3] = 3.0;
        this.a[2] = 8.0;
        this.a[1] = -100.0;
        this.a[0] = 300.0;
        this.newName = "Polynomial: a4=" + this.a[0] + ",  a3=" + this.a[1] + ",  a2=" + this.a[2] + ", a1=" + this.a[3] + ", a0=" + this.a[4];
        this.h = this.histogramFactory.createHistogram1D("Polynomial", this.xBins, this.xmin, this.xmax);
        this.ff = this.functionFactory.createFunctionByName("Polynomial-4", "P4");
        this.fillff();
        this.checkFitting1Dff(this.newName);
    }

    public void init() {
        this.debug = false;
        this.xBins = 10;
        this.xmin = 0.0;
        this.xmax = 10.0;
        this.analysisFactory = IAnalysisFactory.create();
        this.treeFactory = this.analysisFactory.createTreeFactory();
        this.tree = this.treeFactory.create();
        this.histogramFactory = this.analysisFactory.createHistogramFactory(this.tree);
        this.functionFactory = this.analysisFactory.createFunctionFactory(this.tree);
    }

    public void checkFitting1D(String name) {
    }

    public void checkFitting1Dff(String name) {
    }

    private void fill() {
        for (int i = 0; i < this.xBins; ++i) {
            double x = this.h.binMean(i);
            for (int j = 0; j < this.nRep; ++j) {
                this.h.fill(x, (1.0 + 2.0 * (this.r.nextDouble() - 0.5)) * this.f.value(new double[]{x}) / (double)this.nRep);
            }
        }
    }

    private void fillff() {
        for (int i = 0; i < this.xBins; ++i) {
            double x = this.h.binMean(i);
            for (int j = 0; j < this.nRep; ++j) {
                this.h.fill(x, (1.0 + 2.0 * (this.r.nextDouble() - 0.5)) * this.ff.value(new double[]{x}) / (double)this.nRep);
            }
        }
    }

    private double valueF(double vmin, double vmax) {
        this.ymin = this.f.value(new double[]{vmin});
        this.ymax = this.f.value(new double[]{vmax});
        if (this.ymin > this.ymax) {
            double tmp = this.ymin;
            this.ymin = this.ymax;
            this.ymax = tmp;
        }
        double x = this.r.nextDouble() * (vmax - vmin) + vmin;
        double y = this.r.nextDouble() * (this.ymax - this.ymin) + this.ymin;
        while (true) {
            double[] dArray = new double[]{x};
            if (!(y > this.f.value(dArray))) break;
            x = this.r.nextDouble() * (vmax - vmin) + vmin;
            y = this.r.nextDouble();
        }
        return x;
    }

    private double valueG(double vmin, double vmax) {
        return this.r.nextGaussian() * (vmax - vmin) / 3.0 + (vmin + vmax) / 2.0;
    }
}

