/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.Principal;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.plugins.IMapCredentialsClient;
import org.dcache.gplazma.plugins.PrivilegeDelegate;
import org.dcache.gplazma.util.CertificateUtils;
import org.dcache.util.NetworkUtils;
import org.glite.voms.PKIVerifier;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;
import org.glite.voms.ac.AttributeCertificate;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.ietf.jgss.GSSException;
import org.opensciencegrid.authz.xacml.common.LocalId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class XACMLPlugin
implements GPlazmaAuthenticationPlugin {
    static final String CADIR = "gplazma.vomsdir.ca";
    static final String VOMSDIR = "gplazma.vomsdir.dir";
    static final String VATTR_VALIDATE = "gplazma.voms.validate";
    static final String ILLEGAL_CACHE_SIZE = "cache size must be non-zero positive integer; was: ";
    static final String ILLEGAL_CACHE_LIFE = "cache life must be positive integer; was: ";
    static final String DENIED_MESSAGE = "Permission Denied: No XACML mapping retrieved for extensions ";
    static final String HOST_CREDENTIAL_ERROR = "Could not load host globus credentials ";
    static final String SERVICE_URL_PROPERTY = "gplazma.xacml.service.url";
    static final String CLIENT_TYPE_PROPERTY = "gplazma.xacml.client.type";
    static final String SERVICE_KEY = "/etc/grid-security/hostkey.pem";
    static final String SERVICE_CERT = "/etc/grid-security/hostcert.pem";
    static final String SERVICE_CAs = "/etc/grid-security/certificates/*.0";
    static final String CACHE_LIFETIME = "gplazma.xacml.cachelife.secs";
    static final String CACHE_SIZE = "gplazma.xacml.cache.maxsize";
    private static final Logger logger = LoggerFactory.getLogger(XACMLPlugin.class);
    private static final String DEFAULT_CACHE_LIFETIME = "30";
    private static final String DEFAULT_CACHE_SIZE = "1024";
    private Cache<VomsExtensions, LocalId> _localIdCache;
    private final String _caDirectory;
    private final String _vomsDirectory;
    private final Map<?, ?> _mdcContext;
    private boolean _vomsAttrValidate = false;
    private final String _mappingServiceURL;
    private final Properties _properties;
    private Class _clientType;
    private String _targetServiceName;
    private String _targetServiceIssuer;
    private String _resourceDNSHostName;

    public XACMLPlugin(Properties properties) throws ClassNotFoundException, GSSException, SocketException {
        this._properties = properties;
        String pki = properties.getProperty(VATTR_VALIDATE);
        if (pki != null) {
            this._vomsAttrValidate = Boolean.parseBoolean(pki);
        }
        this._caDirectory = properties.getProperty(CADIR);
        this._vomsDirectory = properties.getProperty(VOMSDIR);
        this._mdcContext = MDC.getCopyOfContextMap();
        this._mappingServiceURL = properties.getProperty(SERVICE_URL_PROPERTY);
        Preconditions.checkArgument((this._mappingServiceURL != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.xacml.service.url");
        this.setClientType(properties.getProperty(CLIENT_TYPE_PROPERTY));
        this.configureTargetServiceInfo();
        this.configureResourceDNSHostName();
        this.configureCache();
        logger.info("XACML plugin now loaded for URL {}", (Object)this._mappingServiceURL);
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        if (Iterables.any(identifiedPrincipals, (Predicate)Predicates.instanceOf(UserNamePrincipal.class))) {
            throw new AuthenticationException("username already defined");
        }
        VOMSValidator validator = new VOMSValidator(null, new ACValidator(this.getPkiVerifier()));
        HashSet<VomsExtensions> extensions = new HashSet<VomsExtensions>();
        for (Object credential : publicCredentials) {
            if (!(credential instanceof X509Certificate[])) continue;
            this.extractExtensionsFromChain((X509Certificate[])credential, extensions, validator);
        }
        if (extensions.isEmpty()) {
            throw new AuthenticationException("no FQANs found");
        }
        Principal login = (Principal)Iterables.find(identifiedPrincipals, (Predicate)Predicates.instanceOf(LoginNamePrincipal.class), null);
        String userName = this.getMappingFor(login, extensions);
        if (userName == null) {
            throw new AuthenticationException("no mapping for: " + extensions);
        }
        identifiedPrincipals.add((Principal)new UserNamePrincipal(userName));
    }

    private void configureCache() throws IllegalArgumentException {
        int expiry = Integer.parseInt(this._properties.getProperty(CACHE_LIFETIME, DEFAULT_CACHE_LIFETIME));
        if (expiry < 0) {
            throw new IllegalArgumentException(ILLEGAL_CACHE_LIFE + expiry);
        }
        int size = Integer.parseInt(this._properties.getProperty(CACHE_SIZE, DEFAULT_CACHE_SIZE));
        if (size < 1) {
            throw new IllegalArgumentException(ILLEGAL_CACHE_SIZE + size);
        }
        this._localIdCache = CacheBuilder.newBuilder().expireAfterAccess((long)expiry, TimeUnit.SECONDS).maximumSize(size).softValues().build((CacheLoader)new XACMLFetcher());
    }

    private void configureResourceDNSHostName() throws SocketException {
        List addressList = NetworkUtils.getLocalAddresses();
        if (addressList.isEmpty()) {
            return;
        }
        Collections.sort(addressList, NetworkUtils.getExternalInternalSorter());
        this._resourceDNSHostName = ((InetAddress)addressList.get(0)).getCanonicalHostName();
    }

    private void configureTargetServiceInfo() throws GSSException {
        GlobusCredential serviceCredential;
        try {
            serviceCredential = new GlobusCredential(SERVICE_CERT, SERVICE_KEY);
        }
        catch (GlobusCredentialException gce) {
            throw new GSSException(13, 0, HOST_CREDENTIAL_ERROR + gce.toString());
        }
        this._targetServiceName = serviceCredential.getIdentity();
        this._targetServiceIssuer = CertificateUtils.toGlobusDN((String)serviceCredential.getIssuer(), (boolean)true);
    }

    private void extractExtensionsFromChain(X509Certificate[] chain, Set<VomsExtensions> extensionsSet, VOMSValidator validator) throws AuthenticationException {
        if (chain == null) {
            return;
        }
        String proxySubject = CertificateUtils.getSubjectFromX509Chain((X509Certificate[])chain, (boolean)false);
        String proxySubjectIssuer = CertificateUtils.getSubjectX509Issuer((X509Certificate[])chain, (boolean)true);
        String vomsSubject = CertificateUtils.getSubjectX509Issuer((X509Certificate[])chain, (boolean)false);
        if (this._vomsAttrValidate) {
            validator.setClientChain(chain).validate();
        } else {
            validator.setClientChain(chain).parse();
        }
        for (Object attr : validator.getVOMSAttributes()) {
            X500Principal x500;
            VOMSAttribute vomsAttr = (VOMSAttribute)attr;
            VomsExtensions vomsExtensions = new VomsExtensions();
            vomsExtensions._x509Subject = proxySubject;
            vomsExtensions._x509SubjectIssuer = proxySubjectIssuer;
            vomsExtensions._vo = vomsAttr.getVO();
            vomsExtensions._vomsSubject = vomsSubject;
            AttributeCertificate ac = vomsAttr.getAC();
            if (ac != null && (x500 = ac.getIssuer()) != null) {
                vomsExtensions._vomsSubjectIssuer = CertificateUtils.toGlobusDN((String)x500.toString(), (boolean)true);
            }
            boolean primary = true;
            for (Object fqan : vomsAttr.getFullyQualifiedAttributes()) {
                vomsExtensions._fqan = (String)fqan;
                vomsExtensions._primary = primary;
                primary = false;
                logger.debug(" {} authenticate, adding voms extensions = {}", (Object)this, (Object)vomsExtensions);
                extensionsSet.add(vomsExtensions);
            }
        }
    }

    private String getMappingFor(Principal login, Set<VomsExtensions> extensionSet) {
        for (VomsExtensions extensions : extensionSet) {
            try {
                LocalId localId = (LocalId)this._localIdCache.get((Object)extensions);
                String name = localId.getUserName();
                if (login != null && !login.getName().equals(name)) continue;
                logger.debug("getMappingFor {} = {}", (Object)extensions, (Object)name);
                return name;
            }
            catch (ExecutionException t) {
                logger.debug("could not find mapping for {}; continuing ...", (Object)extensions);
            }
        }
        return null;
    }

    private PKIVerifier getPkiVerifier() throws AuthenticationException {
        try {
            return CertificateUtils.getPkiVerifier((String)this._vomsDirectory, (String)this._caDirectory, this._mdcContext);
        }
        catch (CertificateException t) {
            throw new AuthenticationException(t.getMessage(), (Throwable)t);
        }
        catch (CRLException t) {
            throw new AuthenticationException(t.getMessage(), (Throwable)t);
        }
        catch (IOException t) {
            logger.error("Failed to load PKI stores: {}", (Object)t.getMessage());
            throw new AuthenticationException(t.getMessage(), (Throwable)t);
        }
    }

    private IMapCredentialsClient newClient() throws AuthenticationException {
        if (this._clientType != null) {
            try {
                return (IMapCredentialsClient)this._clientType.newInstance();
            }
            catch (InstantiationException t) {
                throw new AuthenticationException(t.getMessage(), (Throwable)t);
            }
            catch (IllegalAccessException t) {
                throw new AuthenticationException(t.getMessage(), (Throwable)t);
            }
        }
        throw new AuthenticationException("no client type has been defined");
    }

    private void setClientType(String property) throws ClassNotFoundException {
        this._clientType = property == null ? PrivilegeDelegate.class : Class.forName(property, true, Thread.currentThread().getContextClassLoader());
    }

    static {
        System.setProperty("sslCAFiles", SERVICE_CAs);
        System.setProperty("sslCertfile", SERVICE_CERT);
        System.setProperty("sslKey", SERVICE_KEY);
    }

    private class XACMLFetcher
    extends CacheLoader<VomsExtensions, LocalId> {
        private XACMLFetcher() {
        }

        public LocalId load(VomsExtensions key) throws Exception {
            LocalId localId;
            logger.debug("No cached mapping for {}; contacting mapping service at {}", (Object)key, (Object)XACMLPlugin.this._mappingServiceURL);
            IMapCredentialsClient xacmlClient = XACMLPlugin.this.newClient();
            xacmlClient.configure(XACMLPlugin.this._properties);
            xacmlClient.setX509Subject(key._x509Subject);
            xacmlClient.setX509SubjectIssuer(key._x509SubjectIssuer);
            xacmlClient.setFqan(key._fqan);
            xacmlClient.setVO(key._vo);
            xacmlClient.setVOMSSigningSubject(key._vomsSubject);
            xacmlClient.setVOMSSigningIssuer(key._vomsSubjectIssuer);
            xacmlClient.setResourceType("http://authz-interop.org/xacml/resource/resource-type/se");
            xacmlClient.setResourceDNSHostName(XACMLPlugin.this._resourceDNSHostName);
            xacmlClient.setResourceX509ID(XACMLPlugin.this._targetServiceName);
            xacmlClient.setResourceX509Issuer(XACMLPlugin.this._targetServiceIssuer);
            xacmlClient.setRequestedaction("http://authz-interop.org/xacml/action/action-type/access");
            try {
                localId = xacmlClient.mapCredentials(XACMLPlugin.this._mappingServiceURL);
            }
            catch (AuthenticationException e) {
                logger.error("Exception occurred in mapCredentials: {}", (Object)e.toString());
                throw e;
            }
            if (localId == null) {
                String denied = XACMLPlugin.DENIED_MESSAGE + key;
                logger.warn(denied);
                throw new AuthenticationException(denied);
            }
            return localId;
        }
    }

    private static class VomsExtensions {
        private String _x509Subject;
        private String _x509SubjectIssuer;
        private String _fqan;
        private boolean _primary;
        private String _vo;
        private String _vomsSubject;
        private String _vomsSubjectIssuer;

        private VomsExtensions() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof VomsExtensions)) {
                return false;
            }
            return this.toString().equals(object.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return VomsExtensions.class.getSimpleName() + "[X509Subject='" + this._x509Subject + "', X509SubjectIssuer='" + this._x509SubjectIssuer + "', fqan='" + this._fqan + "', primary=" + this._primary + ", VO='" + this._vo + "', VOMSSubject='" + this._vomsSubject + "', VOMSSubjectIssuer='" + this._vomsSubjectIssuer + "']";
        }
    }
}

