/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.util.List;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationResponse
extends AbstractResponseMessage {
    public AuthenticationResponse(int sId, int status, int length) {
        super(sId, status, length);
    }

    public AuthenticationResponse(int sId, int status, int length, String protocol, int step, List<XrootdBucket> buckets) {
        super(sId, status, length);
        if (protocol.length() > 4) {
            throw new IllegalArgumentException("Protocol length must not exceed 4. The passed protocol is " + protocol);
        }
        this.putCharSequence(protocol);
        int padding = 4 - protocol.getBytes().length;
        for (int i = 0; i < padding; ++i) {
            this._buffer.writeByte(0);
        }
        this.putSignedInt(step);
        for (XrootdBucket bucket : buckets) {
            bucket.serialize(this._buffer);
        }
        this.putSignedInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
    }
}

