/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import java.util.Arrays;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.HandshakeRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdHandshakeHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdHandshakeHandler.class);
    private final int _serverType;
    private boolean _isHandshaked;

    public XrootdHandshakeHandler(int serverType) {
        this._serverType = serverType;
        this._isHandshaked = false;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        XrootdRequest msg = (XrootdRequest)e.getMessage();
        if (!this._isHandshaked) {
            byte[] response;
            if (!(msg instanceof HandshakeRequest)) {
                _log.error("Invalid handshake");
                Channels.close((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture());
                return;
            }
            byte[] request = ((HandshakeRequest)msg).getHandshake();
            if (!Arrays.equals(request, XrootdProtocol.HANDSHAKE_REQUEST)) {
                _log.error("Received corrupt handshake message (" + request.length + " bytes).");
                Channels.close((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture());
                return;
            }
            switch (this._serverType) {
                case 0: {
                    response = XrootdProtocol.HANDSHAKE_RESPONSE_LOADBALANCER;
                    break;
                }
                case 1: {
                    response = XrootdProtocol.HANDSHAKE_RESPONSE_DATASERVER;
                    break;
                }
                default: {
                    _log.error("Unknown server type (" + this._serverType + ")");
                    Channels.close((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture());
                    return;
                }
            }
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)ChannelBuffers.wrappedBuffer((byte[])response));
            this._isHandshaked = true;
            return;
        }
        super.messageReceived(ctx, e);
    }
}

