/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import com.google.common.collect.ImmutableSet;
import java.security.SecureRandom;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.InvalidHandlerConfigurationException;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.ErrorResponse;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.LoginResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdAuthenticationHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdAuthenticationHandler.class);
    private static final ImmutableSet<Integer> WITHOUT_LOGIN = ImmutableSet.of((Object)3024, (Object)3007, (Object)3006);
    private static final ImmutableSet<Integer> WITHOUT_AUTH = ImmutableSet.of((Object)3000, (Object)3024, (Object)3007, (Object)3011, (Object)3006);
    private static final int SESSION_ID_SIZE = 16;
    private static final SecureRandom _random = new SecureRandom();
    private final AuthenticationFactory _authenticationFactory;
    private AuthenticationHandler _authenticationHandler;
    private State _state = State.NO_LOGIN;
    private Subject _subject;
    private final byte[] _session = new byte[16];

    public XrootdAuthenticationHandler(AuthenticationFactory authenticationFactory) {
        this._authenticationFactory = authenticationFactory;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Object msg = event.getMessage();
        if (!(msg instanceof XrootdRequest)) {
            ctx.sendUpstream((ChannelEvent)event);
            return;
        }
        XrootdRequest request = (XrootdRequest)msg;
        int reqId = request.getRequestId();
        try {
            if (this._state == State.NO_LOGIN && !WITHOUT_LOGIN.contains((Object)reqId)) {
                throw new XrootdException(3010, "Login required");
            }
            if (this._state == State.NO_AUTH && !WITHOUT_AUTH.contains((Object)reqId)) {
                throw new XrootdException(3010, "Authentication required");
            }
            switch (reqId) {
                case 3007: {
                    this.doOnLogin(ctx, event, (LoginRequest)request);
                    break;
                }
                case 3000: {
                    this.doOnAuthentication(ctx, event, (AuthenticationRequest)request);
                    break;
                }
                default: {
                    request.setSubject(this._subject);
                    ctx.sendUpstream((ChannelEvent)event);
                    break;
                }
            }
        }
        catch (XrootdException e) {
            ErrorResponse error = new ErrorResponse(request.getStreamId(), e.getError(), e.getMessage());
            event.getChannel().write((Object)error);
        }
        catch (RuntimeException e) {
            _log.error(String.format("Processing %s failed due to a bug", msg), (Throwable)e);
            ErrorResponse error = new ErrorResponse(request.getStreamId(), 3012, String.format("Internal server error (%s)", e.getMessage()));
            event.getChannel().write((Object)error);
        }
    }

    private void doOnLogin(ChannelHandlerContext context, MessageEvent event, LoginRequest request) throws XrootdException {
        try {
            this._state = State.NO_LOGIN;
            this._subject = null;
            _random.nextBytes(this._session);
            this._authenticationHandler = this._authenticationFactory.createHandler();
            LoginResponse response = new LoginResponse(request.getStreamId(), this._session, this._authenticationHandler.getProtocol());
            if (this._authenticationHandler.isCompleted()) {
                this.authenticated(context, this._authenticationHandler.getSubject());
            } else {
                this._state = State.NO_AUTH;
            }
            event.getChannel().write((Object)response);
        }
        catch (InvalidHandlerConfigurationException e) {
            _log.error("Could not instantiate authentication handler: {}", (Throwable)e);
            throw new XrootdException(3012, "Internal server error");
        }
    }

    private void doOnAuthentication(ChannelHandlerContext context, MessageEvent event, AuthenticationRequest request) throws XrootdException {
        AbstractResponseMessage response = this._authenticationHandler.authenticate(request);
        if (this._authenticationHandler.isCompleted()) {
            this._state = State.NO_LOGIN;
            this.authenticated(context, this._authenticationHandler.getSubject());
        }
        event.getChannel().write((Object)response);
    }

    private void authenticated(ChannelHandlerContext context, Subject subject) throws XrootdException {
        this._subject = this.login(context, subject);
        this._state = State.AUTH;
        this._authenticationHandler = null;
    }

    protected Subject login(ChannelHandlerContext context, Subject subject) throws XrootdException {
        return subject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NO_LOGIN,
        NO_AUTH,
        AUTH;

    }
}

