/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.util;

import gplazma.authz.AuthorizationController;
import gplazma.authz.AuthorizationException;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.glite.voms.BasicVOMSTrustStore;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIVerifier;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACTrustStore;
import org.glite.voms.ac.ACValidator;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.VOMSTrustStore;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.opensciencegrid.authz.xacml.common.FQAN;

public class X509CertUtil {
    public static String default_service_cert = "/etc/grid-security/hostcert.pem";
    public static String default_service_key = "/etc/grid-security/hostkey.pem";
    public static String default_trusted_cacerts = "/etc/grid-security/certificates";
    private static PKIStore caTrustStore = null;
    private static VOMSTrustStore vomsTrustStore = null;
    private static ACTrustStore acTrustStore = null;
    private static VOMSValidator vomsValidator = null;
    private static ACValidator acValidator = null;
    private static PKIVerifier pkiVerifier = null;
    private static int REFRESH_TIME_MS = 20000;

    public static GSSContext getUserContext(String proxy_cert) throws GSSException {
        return X509CertUtil.getUserContext(proxy_cert, default_trusted_cacerts);
    }

    public static GSSContext getUserContext(String proxy_cert, String service_trusted_certs) throws GSSException {
        GlobusCredential userCredential;
        try {
            userCredential = new GlobusCredential(proxy_cert, proxy_cert);
        }
        catch (GlobusCredentialException gce) {
            throw new GSSException(13, 0, "could not load host globus credentials " + gce.toString());
        }
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(userCredential, 0);
        TrustedCertificates trusted_certs = TrustedCertificates.load((String)service_trusted_certs);
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext((GSSCredential)cred);
        context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
        context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)trusted_certs);
        return context;
    }

    public static Socket getGsiClientSocket(String host, int port, ExtendedGSSContext context) throws Exception {
        Socket clientSocket = GssSocketFactory.getDefault().createSocket(host, port, (GSSContext)context);
        ((GssSocket)clientSocket).setWrapMode(2);
        ((GssSocket)clientSocket).setAuthorization((Authorization)NoAuthorization.getInstance());
        return clientSocket;
    }

    public static String toGlobusID(Vector dn) {
        int len = dn.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            Vector rdn = (Vector)dn.elementAt(i);
            String[] ava = (String[])rdn.elementAt(0);
            buf.append('/').append(ava[0]).append('=').append(ava[1]);
        }
        return buf.toString();
    }

    public static String toGlobusDN(String certDN) {
        StringTokenizer tokens = new StringTokenizer(certDN, ",");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            buf.insert(0, token);
            buf.insert(0, "/");
        }
        return buf.toString();
    }

    public static String getSubjectFromX509Chain(X509Certificate[] chain, boolean omitEmail) throws AuthorizationException {
        TBSCertificateStructure tbsCert = X509CertUtil.getUserTBSCertFromX509Chain(chain);
        String subjectDN = X509NameHelper.toString((X509Name)tbsCert.getSubject());
        subjectDN = X509CertUtil.toGlobusString((ASN1Sequence)tbsCert.getSubject().getDERObject(), omitEmail);
        return subjectDN;
    }

    public static TBSCertificateStructure getUserTBSCertFromX509Chain(X509Certificate[] chain) throws AuthorizationException {
        TBSCertificateStructure tbsCert = null;
        X509Certificate clientcert = null;
        try {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate testcert = chain[i];
                tbsCert = BouncyCastleUtil.getTBSCertificateStructure((X509Certificate)testcert);
                int certType = BouncyCastleUtil.getCertificateType((TBSCertificateStructure)tbsCert);
                if (CertUtil.isImpersonationProxy((int)certType)) continue;
                clientcert = chain[i];
                break;
            }
        }
        catch (IOException e) {
            throw new AuthorizationException("Can't extract client certificate: " + e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new AuthorizationException("Can't extract client certificate: " + e.getMessage(), e);
        }
        if (clientcert == null) {
            throw new AuthorizationException("could not find clientcert");
        }
        return tbsCert;
    }

    public static X509Certificate getUserCertFromX509Chain(X509Certificate[] chain) throws Exception {
        TBSCertificateStructure tbsCert = null;
        X509Certificate clientcert = null;
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate testcert = chain[i];
            tbsCert = BouncyCastleUtil.getTBSCertificateStructure((X509Certificate)testcert);
            int certType = BouncyCastleUtil.getCertificateType((TBSCertificateStructure)tbsCert);
            if (CertUtil.isImpersonationProxy((int)certType)) continue;
            clientcert = chain[i];
            break;
        }
        if (clientcert == null) {
            throw new AuthorizationException("could not find clientcert");
        }
        return clientcert;
    }

    public static String getSubjectX509Issuer(X509Certificate[] chain) throws Exception {
        X509Certificate clientcert = X509CertUtil.getUserCertFromX509Chain(chain);
        return X509CertUtil.getSubjectX509Issuer(clientcert);
    }

    public static String getSubjectX509Issuer(X509Certificate cert) throws Exception {
        return X509CertUtil.toGlobusDN(((Object)cert.getIssuerDN()).toString());
    }

    public static Collection<String> getFQANsFromContext(ExtendedGSSContext gssContext, boolean validate) throws AuthorizationException {
        X509Certificate[] chain;
        try {
            chain = (X509Certificate[])gssContext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
        }
        catch (GSSException gsse) {
            throw new AuthorizationException("Could not extract certificate chain from context " + gsse.getMessage() + "\n" + gsse.getCause());
        }
        return X509CertUtil.getFQANsFromX509Chain(chain, validate);
    }

    public static Collection<String> getFQANsFromContext(ExtendedGSSContext gssContext) throws AuthorizationException {
        X509Certificate[] chain;
        try {
            chain = (X509Certificate[])gssContext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
        }
        catch (GSSException gsse) {
            throw new AuthorizationException("Could not extract certificate chain from context " + gsse.getMessage() + "\n" + gsse.getCause());
        }
        return X509CertUtil.getFQANsFromX509Chain(chain, false);
    }

    public static Collection<String> getValidatedFQANsFromX509Chain(X509Certificate[] chain) throws AuthorizationException {
        return X509CertUtil.getFQANsFromX509Chain(chain, true);
    }

    public static Collection<String> getFQANsFromX509Chain(X509Certificate[] chain) throws AuthorizationException {
        return X509CertUtil.getFQANsFromX509Chain(chain, false);
    }

    public static Collection<String> getFQANsFromX509Chain(X509Certificate[] chain, boolean validate) throws AuthorizationException {
        LinkedHashSet<String> fqans = null;
        try {
            List listOfAttributes = X509CertUtil.getVOMSAttributes(chain, validate);
            fqans = X509CertUtil.getFQANSfromVOMSAttributes(listOfAttributes);
        }
        catch (AuthorizationException ae) {
            throw new AuthorizationException(ae.toString());
        }
        catch (Exception e) {
            throw new AuthorizationException("Could not validate role.");
        }
        return fqans;
    }

    public static LinkedHashSet<String> getFQANSfromVOMSAttributes(List listOfAttributes) {
        LinkedHashSet<String> fqans = new LinkedHashSet<String>();
        for (VOMSAttribute vomsAttribute : listOfAttributes) {
            List listOfFqans = vomsAttribute.getFullyQualifiedAttributes();
            for (String attr : listOfFqans) {
                if (attr.endsWith("/Capability=NULL")) {
                    attr = attr.substring(0, attr.length() - AuthorizationController.capnulllen);
                }
                if (attr.endsWith("/Role=NULL")) {
                    attr = attr.substring(0, attr.length() - AuthorizationController.rolenulllen);
                }
                fqans.add(attr);
            }
        }
        return fqans;
    }

    public static AttributeCertificate getAttributeCertificate(X509Certificate[] chain, String fqan) throws AuthorizationException {
        return X509CertUtil.getVOMSAttribute(chain, fqan).getAC();
    }

    public static VOMSAttribute getVOMSAttribute(X509Certificate[] chain, String fqan) throws AuthorizationException {
        if (fqan.endsWith("/Capability=NULL")) {
            fqan = fqan.substring(0, fqan.length() - AuthorizationController.capnulllen);
        }
        if (fqan.endsWith("/Role=NULL")) {
            fqan = fqan.substring(0, fqan.length() - AuthorizationController.rolenulllen);
        }
        List listOfAttributes = X509CertUtil.getVOMSAttributes(chain, false);
        for (VOMSAttribute vomsAttribute : listOfAttributes) {
            List listOfFqans = vomsAttribute.getFullyQualifiedAttributes();
            for (String attr : listOfFqans) {
                String attrtmp = attr;
                if (attrtmp.endsWith("/Capability=NULL")) {
                    attrtmp = attrtmp.substring(0, attrtmp.length() - AuthorizationController.capnulllen);
                }
                if (attrtmp.endsWith("/Role=NULL")) {
                    attrtmp = attrtmp.substring(0, attrtmp.length() - AuthorizationController.rolenulllen);
                }
                if (!attrtmp.equals(fqan)) continue;
                return vomsAttribute;
            }
        }
        return null;
    }

    public static synchronized List getVOMSAttributes(X509Certificate[] chain, boolean validate) throws AuthorizationException {
        try {
            VOMSValidator validator = X509CertUtil.getVOMSValidatorInstance();
            validator.setClientChain(chain);
            if (validate) {
                validator.validate();
            } else {
                validator.parse();
            }
            return validator.getVOMSAttributes();
        }
        catch (IOException ioe) {
            throw new AuthorizationException("Could not read trust stores " + ioe.getMessage() + "\n" + ioe.getCause());
        }
        catch (CertificateException ce) {
            throw new AuthorizationException("Could not read certificate " + ce.getMessage() + "\n" + ce.getCause());
        }
        catch (CRLException crle) {
            throw new AuthorizationException("Could not read CRL " + crle.getMessage() + "\n" + crle.getCause());
        }
    }

    public static String parseGroupFromFQAN(String fqan) {
        StringTokenizer st;
        String group = null;
        if (fqan != null && (st = new StringTokenizer(group = new FQAN(fqan).getGroup(), "/")).hasMoreTokens()) {
            group = "/" + st.nextToken();
        }
        return group;
    }

    public static String toGlobusString(ASN1Sequence seq, boolean omitEmail) {
        if (seq == null) {
            return null;
        }
        Enumeration e = seq.getObjects();
        StringBuffer buf = new StringBuffer();
        while (e.hasMoreElements()) {
            ASN1Set set = (ASN1Set)e.nextElement();
            Enumeration ee = set.getObjects();
            boolean didappend = false;
            while (ee.hasMoreElements()) {
                ASN1Sequence s = (ASN1Sequence)ee.nextElement();
                DERObjectIdentifier oid = (DERObjectIdentifier)s.getObjectAt(0);
                String sym = (String)X509Name.OIDLookUp.get(oid);
                if (oid.equals((Object)X509Name.EmailAddress) && omitEmail) continue;
                if (!didappend) {
                    buf.append('/');
                    didappend = true;
                }
                if (sym == null) {
                    buf.append(oid.getId());
                } else {
                    buf.append(sym);
                }
                buf.append('=');
                buf.append(((DERString)s.getObjectAt(1)).getString());
                if (!ee.hasMoreElements()) continue;
                buf.append('+');
            }
        }
        return buf.toString();
    }

    public static synchronized VOMSValidator getVOMSValidatorInstance() throws IOException, CertificateException, CRLException {
        String caDir;
        if (vomsValidator != null) {
            return vomsValidator;
        }
        PKIStore vomsStore = null;
        String vomsDir = System.getProperty("VOMSDIR");
        vomsDir = vomsDir == null ? PKIStore.DEFAULT_VOMSDIR : vomsDir;
        File theDir = new File(vomsDir);
        if (theDir.exists() && theDir.isDirectory() && theDir.list().length > 0) {
            vomsStore = new PKIStore(vomsDir, 1, true);
            vomsStore.rescheduleRefresh(900000);
        }
        caDir = (caDir = System.getProperty("CADIR")) == null ? PKIStore.DEFAULT_CADIR : caDir;
        PKIStore caStore = new PKIStore(caDir, 2, true);
        caStore.rescheduleRefresh(900000);
        vomsValidator = new VOMSValidator(null, new ACValidator(new PKIVerifier((VOMSTrustStore)vomsStore, caStore)));
        return vomsValidator;
    }

    public static synchronized ACTrustStore getACTrustStoreInstance() throws IOException, CertificateException, CRLException {
        if (acTrustStore != null) {
            return acTrustStore;
        }
        acTrustStore = new BasicVOMSTrustStore(PKIStore.DEFAULT_CADIR, 43200000L);
        ((BasicVOMSTrustStore)acTrustStore).stopRefresh();
        return acTrustStore;
    }
}

