/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.util;

import gplazma.authz.util.X509CertUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class HostUtil {
    public static String[] getHosts() throws SocketException {
        InetAddress[] addresses = HostUtil.getInetAddress();
        String[] hosts = new String[addresses.length];
        int nextExternalIfIndex = 0;
        int nextInternalIfIndex = addresses.length - 1;
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress addr = addresses[i];
            if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || addr.isSiteLocalAddress() || addr.isMulticastAddress()) {
                hosts[nextInternalIfIndex--] = addr.getHostName();
                continue;
            }
            hosts[nextExternalIfIndex++] = addr.getHostName();
        }
        return hosts;
    }

    public static InetAddress[] getInetAddress() throws SocketException {
        Enumeration<NetworkInterface> ifList = NetworkInterface.getNetworkInterfaces();
        Vector<InetAddress> v = new Vector<InetAddress>();
        while (ifList.hasMoreElements()) {
            NetworkInterface ne = ifList.nextElement();
            Enumeration<InetAddress> ipEnumeration = ne.getInetAddresses();
            while (ipEnumeration.hasMoreElements()) {
                InetAddress ia = ipEnumeration.nextElement();
                if (ia.isLoopbackAddress()) continue;
                v.add(ia);
            }
        }
        return v.toArray(new InetAddress[0]);
    }

    public static GSSContext getServiceContext() throws GSSException {
        return HostUtil.getServiceContext(X509CertUtil.default_service_cert, X509CertUtil.default_service_key, X509CertUtil.default_trusted_cacerts);
    }

    public static GSSContext getServiceContext(String service_cert, String service_key, String service_trusted_certs) throws GSSException {
        GlobusCredential serviceCredential;
        try {
            serviceCredential = new GlobusCredential(service_cert, service_key);
        }
        catch (GlobusCredentialException gce) {
            throw new GSSException(13, 0, "could not load host globus credentials " + gce.toString());
        }
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(serviceCredential, 0);
        TrustedCertificates trusted_certs = TrustedCertificates.load((String)service_trusted_certs);
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext((GSSCredential)cred);
        context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
        context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)trusted_certs);
        return context;
    }
}

