/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.records;

import gplazma.authz.records.AuthorizationRecordBase;
import java.io.Serializable;
import java.util.Arrays;

public class gPlazmaAuthorizationRecord
extends AuthorizationRecordBase
implements Serializable {
    private static final long serialVersionUID = 4793270902707803837L;
    private Object custom_record;

    public gPlazmaAuthorizationRecord(String user, boolean readOnly, int priority, int uid, int[] gids, String home, String root, String fsroot) {
        super(user, readOnly, priority, uid, gids, home, root, fsroot);
    }

    public gPlazmaAuthorizationRecord(Object obj) {
        this(null, true, 0, -1, null, "", "", "");
        this.custom_record = obj;
    }

    public gPlazmaAuthorizationRecord() {
    }

    public Object getCustomRecord() {
        return this.custom_record;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getUsername());
        if (this.isReadOnly()) {
            sb.append(" read-only");
        } else {
            sb.append(" read-write");
        }
        sb.append(' ').append(this.getPriority()).append(' ');
        sb.append(this.getUID()).append(' ');
        for (int gid : this.getGIDs()) {
            sb.append(gid).append(' ');
        }
        sb.append(this.getHome()).append(' ');
        sb.append(this.getRoot()).append(' ');
        sb.append(this.getFsRoot()).append('\n');
        return sb.toString();
    }

    public String toDetailedString() {
        StringBuffer sb = new StringBuffer(" User Authentication Record for ");
        sb.append(this.getUsername()).append(" :\n");
        sb.append("      read-only = ").append(this.readOnlyStr()).append("\n");
        sb.append("       priority = ").append(this.getPriority()).append('\n');
        sb.append("            UID = ").append(this.getUID()).append('\n');
        sb.append("            GIDs = ").append(this.getGIDs());
        sb.append("           Home = ").append(this.getHome()).append('\n');
        sb.append("           Root = ").append(this.getRoot()).append('\n');
        sb.append("         FsRoot = ").append(this.getFsRoot()).append('\n');
        return sb.toString();
    }

    public String toShortString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getUsername()).append(" ").append(this.getUID()).append(" ").append(Arrays.toString(this.getGIDs())).append(" ").append(this.getRoot());
        return sb.toString();
    }

    public boolean isValid() {
        return this.getUsername() != null;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isWeak() {
        return false;
    }
}

