/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.records;

import gplazma.authz.records.AuthorizationRecordBase;

public class PasswordRecord
extends AuthorizationRecordBase {
    String Password = null;

    public PasswordRecord(String user, String passwd, boolean readOnly, int priority, int uid, int[] gids, String home, String root, String fsroot) {
        this(user, passwd, readOnly, priority, uid, gids, home, root, fsroot, false);
    }

    public PasswordRecord(String user, String passwd, boolean readOnly, int priority, int uid, int[] gids, String home, String root, String fsroot, boolean isPlain) {
        super(user, readOnly, priority, uid, gids, home, root, fsroot);
        if (isPlain) {
            this.setPassword(passwd);
        } else {
            this.Password = passwd;
        }
    }

    public String serialize() {
        String str = this.getUsername() + " " + this.Password + " " + this.readOnlyStr() + " " + this.getPriority() + " " + this.getUID() + " " + this.getGIDs() + " " + this.getHome() + " " + this.getRoot();
        if (!this.getRoot().equals(this.getFsRoot())) {
            str = str + " " + this.getFsRoot();
        }
        return str;
    }

    public String toString() {
        return this.serialize();
    }

    public String toDetailedString() {
        StringBuffer stringbuffer = new StringBuffer(" User Password Record for ");
        stringbuffer.append(this.getUsername()).append(" :\n");
        stringbuffer.append("  Password Hash = ").append(this.Password).append('\n');
        stringbuffer.append("      read-only = " + this.readOnlyStr() + "\n");
        stringbuffer.append("       priority = ").append(this.getPriority()).append('\n');
        stringbuffer.append("            UID = ").append(this.getUID()).append('\n');
        stringbuffer.append("            GID = ").append(this.getGIDs()).append('\n');
        stringbuffer.append("           Home = ").append(this.getHome()).append('\n');
        stringbuffer.append("           Root = ").append(this.getRoot()).append('\n');
        stringbuffer.append("         FsRoot = ").append(this.getFsRoot()).append('\n');
        return stringbuffer.toString();
    }

    public String hashPassword(String pwd) {
        String uandp = "1234567890" + this.getUsername() + " " + pwd;
        return Integer.toHexString(uandp.hashCode());
    }

    public void setPassword(String pwd) {
        this.Password = pwd.equals("-") ? "-" : this.hashPassword(pwd);
    }

    public void disable() {
        this.Password = "#";
    }

    public boolean passwordIsValid(String clear_pwd) {
        return this.Password.equals(this.hashPassword(clear_pwd));
    }

    public boolean isDisabled() {
        return this.Password.equals("#");
    }

    public boolean isAnonymous() {
        return this.Password.equals("-");
    }

    public boolean isWeak() {
        return true;
    }

    public boolean isValid() {
        return this.getUsername() != null && this.Password != null;
    }
}

