/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.records;

import gplazma.authz.records.gPlazmaAuthorizationRecord;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

public class DynamicAuthorizationRecord
extends gPlazmaAuthorizationRecord {
    LinkedHashMap strvals = new LinkedHashMap();
    public String subjectDN;
    public String role;

    public DynamicAuthorizationRecord(DynamicAuthorizationRecord dynrecord) {
        this(dynrecord.getStringValues().get("$cmd"), dynrecord.getStringValues().get("$name"), dynrecord.getStringValues().get("$rw"), dynrecord.getStringValues().get("$priority"), dynrecord.getStringValues().get("$uid"), dynrecord.getStringValues().get("$gid"), dynrecord.getStringValues().get("$home"), dynrecord.getStringValues().get("$root"), dynrecord.getStringValues().get("$fsroot"));
    }

    public DynamicAuthorizationRecord(String dynkey, String user, String readonly_str, String priority_str, String uid_str, String gid_str, String home, String root, String fsroot) {
        super(user, readonly_str.equals("read-only"), DynamicAuthorizationRecord.tryParse(priority_str, 0), DynamicAuthorizationRecord.tryParse(uid_str, -1), DynamicAuthorizationRecord.tryParseCSV(gid_str, new int[]{-1}), home, root, fsroot);
        this.strvals.put("$cmd", dynkey);
        this.strvals.put("$name", user);
        this.strvals.put("$rw", readonly_str);
        this.strvals.put("$priority", priority_str);
        this.strvals.put("$uid", uid_str);
        this.strvals.put("$gid", gid_str);
        this.strvals.put("$home", home);
        this.strvals.put("$root", root);
        this.strvals.put("$fsroot", fsroot);
    }

    public DynamicAuthorizationRecord() {
        this(null, null, "true", "0", "-1", "-1", "", "", "");
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator keys = this.strvals.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(' ').append(this.strvals.get(keys.next()));
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public String toDetailedString() {
        StringBuffer sb = new StringBuffer(" User Authentication Record ");
        for (String key : this.strvals.keySet()) {
            sb.append("         " + key + " = " + this.strvals.get(key) + "\n");
        }
        sb.append('\n');
        return sb.toString();
    }

    public static int tryParse(String int_str, int excepval) {
        try {
            return Integer.parseInt(int_str);
        }
        catch (NumberFormatException e) {
            return excepval;
        }
    }

    public static int[] tryParseCSV(String int_str, int[] excepval) {
        try {
            StringTokenizer st1 = new StringTokenizer(int_str, ",");
            int[] gids = new int[st1.countTokens()];
            int i = 0;
            while (st1.hasMoreTokens()) {
                gids[i] = Integer.parseInt(st1.nextToken());
                ++i;
            }
            return gids;
        }
        catch (NumberFormatException e) {
            return excepval;
        }
    }

    @Override
    public boolean isValid() {
        return this.getUsername() != null;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    public LinkedHashMap<String, String> getStringValues() {
        return this.strvals;
    }
}

