/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.records;

import gplazma.authz.records.AuthorizationRecordBase;
import gplazma.authz.records.DynamicAuthorizationRecord;
import gplazma.authz.records.PasswordRecord;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCacheSRMauthzRecordsService {
    private static final Logger log = LoggerFactory.getLogger(DCacheSRMauthzRecordsService.class);
    private static final String STORAGE_AUTHZ_FILENAME = "storage-authzdb";
    private static final String PWD_RECORD_MARKER = "passwd ";
    private static final String AUTH_RECORD_MARKER = "authorize ";
    private static final String DYNAMIC_RECORD_MARKER = "dynamic";
    private static final String FILE_VERSION_MARKER = "version ";
    private double fileVersion;
    private LinkedHashMap auth_records = null;
    private LinkedHashMap pwd_records = null;
    private LinkedHashMap dynamic_records = null;
    private static double fileVersion_static;
    private static LinkedHashMap auth_records_static;
    private static LinkedHashMap pwd_records_static;
    private static LinkedHashMap dynamic_records_static;
    private static long prev_refresh_time;
    private static String prev_filename;
    static final String dynamic_mapper = "gplazma.authz.records.DynamicMappingMethods";
    static final Map<String, Method> dynamic_methods;

    public DCacheSRMauthzRecordsService(String filename) throws IOException {
        try {
            String fileSeparator = System.getProperty("file.separator");
            String[] testFilenamePath = filename.split(fileSeparator);
            String testFilename = testFilenamePath[testFilenamePath.length - 1];
            if (!testFilename.equals(STORAGE_AUTHZ_FILENAME)) {
                log.warn("Storage Authorization Db filename " + testFilename + " is not as expected.");
                log.warn("WARNING: Possible security violation.");
            }
        }
        catch (SecurityException se) {
            log.error("Exception in testing filename: " + se);
        }
        log.debug("DCacheSRMauthzRecordsService reading " + filename);
        this.read(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void read(String filename) throws IOException {
        boolean readable;
        long current_time = System.currentTimeMillis();
        File config = new File(filename);
        boolean bl = readable = config.canRead() || prev_refresh_time == 0L;
        if (!readable) {
            log.error("WARNING: Could not read storage-authzdb file " + filename + ". Will use cached copy.");
        }
        if (readable && (config.lastModified() >= prev_refresh_time || !filename.equals(prev_filename))) {
            FileReader fr = new FileReader(config);
            BufferedReader reader = new BufferedReader(fr);
            try {
                this.read(reader);
            }
            finally {
                reader.close();
            }
            prev_refresh_time = current_time;
            prev_filename = filename;
            fileVersion_static = this.fileVersion;
            auth_records_static = this.auth_records;
            pwd_records_static = this.pwd_records;
            dynamic_records_static = this.dynamic_records;
        } else {
            this.fileVersion = fileVersion_static;
            this.auth_records = auth_records_static;
            this.pwd_records = pwd_records_static;
            this.dynamic_records = dynamic_records_static;
        }
    }

    private void read(BufferedReader reader) throws IOException {
        String line;
        boolean eof = false;
        while ((line = reader.readLine()) != null) {
            AuthorizationRecordBase rec;
            if ((line = line.trim()).startsWith(AUTH_RECORD_MARKER)) {
                rec = this.readNextAuthorizationRecord(line = line.substring(AUTH_RECORD_MARKER.length()), reader);
                if (rec != null) {
                    if (this.auth_records == null) {
                        this.auth_records = new LinkedHashMap();
                    }
                    this.auth_records.put(rec.getUsername(), rec);
                    continue;
                }
                log.warn("WARNING: could not parse storage-authzdb line into authorization record: " + line);
                continue;
            }
            if (line.startsWith(DYNAMIC_RECORD_MARKER)) {
                String dynkey = new StringTokenizer(line).nextToken();
                DynamicAuthorizationRecord rec2 = this.readNextDynamicRecord(dynkey, line = line.substring(dynkey.length()).trim());
                if (rec2 != null) {
                    if (this.dynamic_records == null) {
                        this.dynamic_records = new LinkedHashMap();
                    }
                    this.dynamic_records.put(rec2.getUsername(), rec2);
                    continue;
                }
                log.warn("WARNING: could not parse storage-authzdb line into dynamic record: " + line);
                continue;
            }
            if (line.startsWith(PWD_RECORD_MARKER)) {
                rec = this.readNextPasswordRecord(line = line.substring(PWD_RECORD_MARKER.length()));
                if (rec != null) {
                    if (this.pwd_records == null) {
                        this.pwd_records = new LinkedHashMap();
                    }
                    this.pwd_records.put(rec.getUsername(), rec);
                    continue;
                }
                log.warn("WARNING: could not parse storage-authzdb line into password record: " + line);
                continue;
            }
            if (!line.startsWith(FILE_VERSION_MARKER)) continue;
            line = line.substring(FILE_VERSION_MARKER.length());
            line = line.trim();
            this.fileVersion = Double.parseDouble(line);
        }
    }

    private gPlazmaAuthorizationRecord readNextAuthorizationRecord(String line, BufferedReader reader) throws IOException {
        String fsroot;
        String root;
        StringTokenizer t = new StringTokenizer(line);
        int ntokens = t.countTokens();
        if (ntokens < 7) {
            return null;
        }
        String user = t.nextToken();
        boolean readOnly = t.nextToken().equals("read-only");
        int priority = this.fileVersion >= 2.2 && ntokens > 7 ? Integer.parseInt(t.nextToken()) : 0;
        String uid_str = t.nextToken();
        int uid = Integer.parseInt(uid_str);
        StringTokenizer st1 = new StringTokenizer(t.nextToken(), ",");
        int[] gids = new int[st1.countTokens()];
        int i = 0;
        while (st1.hasMoreTokens()) {
            gids[i] = Integer.parseInt(st1.nextToken());
            ++i;
        }
        String home = t.nextToken();
        gPlazmaAuthorizationRecord rec = new gPlazmaAuthorizationRecord(user, readOnly, priority, uid, gids, home, root = t.nextToken(), fsroot = t.nextToken());
        if (rec.isValid()) {
            return rec;
        }
        return null;
    }

    private DynamicAuthorizationRecord readNextDynamicRecord(String dynkey, String line) throws IOException {
        String fsroot;
        String root;
        String home;
        String gid_str;
        String uid_str;
        String priority_str;
        String readonly;
        StringTokenizer t = new StringTokenizer(line);
        int ntokens = t.countTokens();
        if (ntokens < 7) {
            return null;
        }
        String user = t.nextToken();
        DynamicAuthorizationRecord rec = new DynamicAuthorizationRecord(dynkey, user, readonly = t.nextToken(), priority_str = this.fileVersion >= 2.2 && ntokens > 7 ? t.nextToken() : "0", uid_str = t.nextToken(), gid_str = t.nextToken(), home = t.nextToken(), root = t.nextToken(), fsroot = t.nextToken());
        if (rec.isValid()) {
            return rec;
        }
        return null;
    }

    private PasswordRecord readNextPasswordRecord(String line) {
        String fsroot;
        String root;
        StringTokenizer t = new StringTokenizer(line);
        int ntokens = t.countTokens();
        if (ntokens < 7) {
            return null;
        }
        String username = t.nextToken();
        String passwd = t.nextToken();
        boolean readOnly = t.nextToken().equals("read-only");
        int priority = this.fileVersion >= 2.2 && ntokens > 7 ? Integer.parseInt(t.nextToken()) : 0;
        int uid = Integer.parseInt(t.nextToken());
        StringTokenizer st1 = new StringTokenizer(t.nextToken(), ",");
        int[] gids = new int[st1.countTokens()];
        int i = 0;
        while (st1.hasMoreTokens()) {
            gids[i] = Integer.parseInt(st1.nextToken());
            ++i;
        }
        String home = t.nextToken();
        PasswordRecord rec = new PasswordRecord(username, passwd, readOnly, priority, uid, gids, home, root = t.nextToken(), fsroot = t.nextToken());
        if (rec.isValid()) {
            return rec;
        }
        return null;
    }

    public PasswordRecord getStoragePasswordRecord(String username) {
        return (PasswordRecord)this.pwd_records.get(username);
    }

    public gPlazmaAuthorizationRecord getStorageUserRecord(String username) {
        if (this.auth_records == null) {
            return null;
        }
        gPlazmaAuthorizationRecord record = (gPlazmaAuthorizationRecord)this.auth_records.get(username);
        if (record == null) {
            record = this.getDynamicAuthorizationRecord(username);
        }
        return record;
    }

    public DynamicAuthorizationRecord getDynamicAuthorizationRecord(String dynkey) {
        if (this.dynamic_records == null) {
            return null;
        }
        return (DynamicAuthorizationRecord)this.dynamic_records.get(dynkey);
    }

    public static String getDynamicMapper() {
        return dynamic_mapper;
    }

    public static Map getDynamicMethods() {
        return dynamic_methods;
    }

    static {
        prev_refresh_time = 0L;
        dynamic_methods = new HashMap<String, Method>();
        try {
            Method[] methods;
            Class<?> DynamicMapper = Class.forName(dynamic_mapper);
            for (Method meth : methods = DynamicMapper.getMethods()) {
                dynamic_methods.put(meth.getName(), meth);
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.error("ClassNotFoundException for DynamicMapper gplazma.authz.records.DynamicMappingMethods");
        }
    }
}

