/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.vorolemap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VORoleMapHandler {
    private static final Logger log = LoggerFactory.getLogger(VORoleMapHandler.class);
    private static String logpattern = "%d{MM/dd HH:mm:ss,SSS} %C{1} authRequestID ";
    private static final String GRID_VOROLE_AUTHZ_DB = "grid-vorolemap";
    private HashMap gridFineGrainMap = new HashMap();
    private HashMap<String, LinkedList<String>> gridFineGrainMapMultiple = new HashMap();
    private static HashMap gridFineGrainMap_static;
    private static HashMap<String, LinkedList<String>> gridFineGrainMapMultiple_static;
    private static long prev_refresh_time;

    public VORoleMapHandler(String filename, long authRequestID) throws IOException {
        try {
            String fileSeparator = System.getProperty("file.separator");
            String[] testFilenamePath = filename.split(fileSeparator);
            String testFilename = testFilenamePath[testFilenamePath.length - 1];
            if (!testFilename.equals(GRID_VOROLE_AUTHZ_DB)) {
                log.warn("The Grid-VO-Role database name " + testFilename + " is not as expected.");
                log.warn("WARNING: Possible security violation.");
            }
        }
        catch (Exception se) {
            log.error("Exception in testing file: " + se);
        }
        log.debug("VORoleMapHandler reading " + filename);
        this.read(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void read(String filename) throws IOException {
        boolean readable;
        long current_time = System.currentTimeMillis();
        File config = new File(filename);
        boolean bl = readable = config.canRead() || prev_refresh_time == 0L;
        if (!readable) {
            log.warn("WARNING: Could not read grid-vorolemap file " + filename + ". Will use cached copy.");
        }
        if (readable && config.lastModified() >= prev_refresh_time) {
            FileReader fr = new FileReader(config);
            BufferedReader reader = new BufferedReader(fr);
            try {
                this.read(reader);
            }
            finally {
                reader.close();
            }
            prev_refresh_time = current_time;
            gridFineGrainMap_static = this.gridFineGrainMap;
            gridFineGrainMapMultiple_static = this.gridFineGrainMapMultiple;
        } else {
            this.gridFineGrainMap = gridFineGrainMap_static;
            this.gridFineGrainMapMultiple = gridFineGrainMapMultiple_static;
        }
    }

    private void read(BufferedReader reader) throws IOException {
        String line;
        boolean eof = false;
        while ((line = reader.readLine()) != null) {
            String thisLine = line.trim();
            if (thisLine.length() == 0) continue;
            if (thisLine.charAt(0) == '*') {
                thisLine = "\"*\"" + thisLine.substring(1);
            } else if (thisLine.charAt(0) != '\"') continue;
            thisLine = thisLine.substring(1);
            int secondQuote = thisLine.indexOf(34, 0);
            if (secondQuote == -1) continue;
            String gridSubjectDN = thisLine.substring(0, secondQuote).trim();
            int thirdQuote = thisLine.indexOf(34, secondQuote + 1);
            String mappedUsername = "";
            String gridVORole = "";
            if (thirdQuote == -1) {
                mappedUsername = thisLine.substring(secondQuote + 1).trim();
            } else {
                int fourthQuote = thisLine.indexOf(34, thirdQuote + 1);
                if (fourthQuote == -1) continue;
                gridVORole = thisLine.substring(thirdQuote + 1, fourthQuote).trim();
                mappedUsername = thisLine.substring(fourthQuote + 1).trim();
            }
            String gridFineGrainIdentity = gridSubjectDN.concat(gridVORole);
            if (mappedUsername == null || mappedUsername.equals("")) continue;
            this.fillMap(gridFineGrainIdentity, mappedUsername);
        }
    }

    private void fillMap(String gridFineGrainIdentity, String username) {
        String mapValue = username;
        String mapKey = gridFineGrainIdentity;
        this.gridFineGrainMap.put(mapKey, mapValue);
        LinkedList<String> mapValues = this.gridFineGrainMapMultiple.get(mapKey);
        if (mapValues == null) {
            mapValues = new LinkedList();
            this.gridFineGrainMapMultiple.put(mapKey, mapValues);
        }
        mapValues.add(mapValue);
    }

    private String removeQuotes(String quotedString) throws Exception {
        if (quotedString != null) {
            quotedString = quotedString.replace('\"', ' ').trim();
        }
        return quotedString;
    }

    public String getMappedUsername(String gridFineGrainSecureId) throws Exception {
        gridFineGrainSecureId = gridFineGrainSecureId.trim();
        return this.removeQuotes((String)this.gridFineGrainMap.get(gridFineGrainSecureId));
    }

    public LinkedList<String> getMappedUsernames(String gridFineGrainSecureId) throws Exception {
        gridFineGrainSecureId = gridFineGrainSecureId.trim();
        return this.gridFineGrainMapMultiple.get(gridFineGrainSecureId);
    }

    public String getMappedUsername(String gridFineGrainSecureId, String username) throws Exception {
        LinkedList<String> mapValues = this.getMappedUsernames(gridFineGrainSecureId = gridFineGrainSecureId.trim());
        if (mapValues != null && mapValues.contains(username)) {
            return username;
        }
        if (mapValues != null && mapValues.contains("\"" + username + "\"")) {
            return username;
        }
        return null;
    }

    static {
        prev_refresh_time = 0L;
    }
}

