/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.vorolemap;

import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.RecordMappingPlugin;
import gplazma.authz.plugins.vorolemap.VORoleMapHandler;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import gplazma.authz.util.X509CertUtil;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VORoleMapAuthzPlugin
extends RecordMappingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(VORoleMapAuthzPlugin.class);
    private final String gridVORoleMapPath;
    private final long authRequestID = 0L;
    gPlazmaAuthorizationRecord authRecord;
    GSSContext context;
    String desiredUserName;
    public static final String capnull = "/Capability=NULL";
    public static final int capnulllen = "/Capability=NULL".length();
    public static final String rolenull = "/Role=NULL";
    public static final int rolenulllen = "/Role=NULL".length();

    public VORoleMapAuthzPlugin(String gridVORoleMapPath, String storageAuthzPath, long authRequestID) throws AuthorizationException {
        super(storageAuthzPath, authRequestID);
        this.gridVORoleMapPath = gridVORoleMapPath;
        logger.info("grid-vorolemap plugin will use " + gridVORoleMapPath);
    }

    public gPlazmaAuthorizationRecord authorize(GSSContext context, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        String fqanValue;
        String gssIdentity;
        if (!(context instanceof ExtendedGSSContext)) {
            logger.error("Received context not instance of ExtendedGSSContext, Plugin exiting ...");
            return null;
        }
        ExtendedGSSContext extendedcontext = (ExtendedGSSContext)context;
        try {
            gssIdentity = ((Object)context.getSrcName()).toString();
        }
        catch (GSSException gsse) {
            logger.error("Caught GSSException in getting DN " + gsse);
            return null;
        }
        try {
            Iterator<String> fqans = X509CertUtil.getFQANsFromContext(extendedcontext).iterator();
            fqanValue = fqans.hasNext() ? fqans.next() : "";
        }
        catch (Exception e) {
            logger.error("Caught Exception in extracting group and role " + e);
            return null;
        }
        return this.authorize(gssIdentity, fqanValue, null, desiredUserName, serviceUrl, socket);
    }

    @Override
    public gPlazmaAuthorizationRecord authorize(String subjectDN, String role, X509Certificate[] chain, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        VORoleMapHandler voRoleMapHandler;
        String user_name = null;
        try {
            voRoleMapHandler = new VORoleMapHandler(this.gridVORoleMapPath, this.getAuthRequestID());
        }
        catch (Exception ase) {
            logger.error("Exception in reading authz-vorole-mapping configuration file: ");
            logger.error(this.gridVORoleMapPath + " " + ase);
            throw new AuthorizationException(ase.toString());
        }
        String identity = role != null ? subjectDN.concat(role) : subjectDN;
        try {
            if ("-".equals(this.mapUsername(voRoleMapHandler, subjectDN))) {
                throw new AuthorizationException("Permission Denied - revocation.: for DN " + subjectDN);
            }
            logger.info("Requesting mapping for User with DN and role: " + identity);
            user_name = this.mapUsername(voRoleMapHandler, identity);
            if (user_name == null && role != null) {
                identity = "*".concat(role);
                user_name = this.mapUsername(voRoleMapHandler, identity);
            }
        }
        catch (Exception e) {
            throw new AuthorizationException(e.toString());
        }
        if (desiredUserName == null) {
            logger.info("Subject DN + Grid Vo Role are mapped to Username: " + user_name);
        }
        if (user_name == null) {
            String denied = "Permission Denied: Cannot determine Username from grid-vorolemap for DN " + subjectDN + " and role " + role;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        if (user_name.equals("-")) {
            String why = ": for DN " + subjectDN + " and role " + role;
            throw new AuthorizationException("Permission Denied - revocation." + why);
        }
        if (desiredUserName != null) {
            logger.debug("Desired Username requested as: " + desiredUserName);
            try {
                user_name = this.mapUsername(voRoleMapHandler, identity, desiredUserName);
                if (user_name == null) {
                    identity = "*".concat(role);
                    user_name = this.mapUsername(voRoleMapHandler, identity, desiredUserName);
                }
            }
            catch (Exception e) {
                throw new AuthorizationException(e.toString());
            }
            if (user_name == null) {
                String denied = "Permission Denied: Requested username " + desiredUserName + " not found for " + subjectDN + " and role " + role;
                logger.warn(denied);
                throw new AuthorizationException(denied);
            }
            if (user_name.equals("-")) {
                String why = ": for DN " + subjectDN + " and role " + role;
                throw new AuthorizationException("Permission Denied - revocation." + why);
            }
        }
        gPlazmaAuthorizationRecord gauthrec = this.getgPlazmaAuthorizationRecord(user_name, subjectDN, role);
        return gauthrec;
    }

    private String mapUsername(VORoleMapHandler gridVORolemapServ, String gridFineGrainIdentity) throws Exception {
        String user_name = gridVORolemapServ.getMappedUsername(gridFineGrainIdentity);
        if (user_name == null) {
            if (gridFineGrainIdentity.endsWith(capnull)) {
                gridFineGrainIdentity = gridFineGrainIdentity.substring(0, gridFineGrainIdentity.length() - capnulllen);
            }
            if (gridFineGrainIdentity.endsWith(rolenull)) {
                gridFineGrainIdentity = gridFineGrainIdentity.substring(0, gridFineGrainIdentity.length() - rolenulllen);
            }
            user_name = gridVORolemapServ.getMappedUsername(gridFineGrainIdentity);
        }
        return user_name;
    }

    private String mapUsername(VORoleMapHandler gridVORolemapServ, String gridFineGrainIdentity, String username) throws Exception {
        String user_name = gridVORolemapServ.getMappedUsername(gridFineGrainIdentity, username);
        if (user_name == null) {
            if (gridFineGrainIdentity.endsWith(capnull)) {
                gridFineGrainIdentity = gridFineGrainIdentity.substring(0, gridFineGrainIdentity.length() - capnulllen);
            }
            if (gridFineGrainIdentity.endsWith(rolenull)) {
                gridFineGrainIdentity = gridFineGrainIdentity.substring(0, gridFineGrainIdentity.length() - rolenulllen);
            }
            user_name = gridVORolemapServ.getMappedUsername(gridFineGrainIdentity, username);
        }
        return user_name;
    }
}

