/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.saz;

import fnal.vox.security.Base64;
import fnal.vox.security.ReadWriteSocket;
import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.AuthorizationPlugin;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import java.net.Socket;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAZAuthorizationPlugin
extends AuthorizationPlugin {
    private long authRequestID = 0L;
    private ReadWriteSocket rwSocket;
    private static final Logger log = LoggerFactory.getLogger(SAZAuthorizationPlugin.class);

    public SAZAuthorizationPlugin(long authRequestID) throws AuthorizationException {
        super(authRequestID);
        log.info("saz plugin now loaded");
    }

    public gPlazmaAuthorizationRecord authorize(X509Certificate[] certs, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        gPlazmaAuthorizationRecord record = null;
        this.rwSocket = new ReadWriteSocket(socket);
        String messageFromServer = null;
        try {
            for (int i = 0; i < certs.length; ++i) {
                String temp = "-----BEGIN CERTIFICATE-----\n";
                byte[] derEncodedByte = certs[i].getEncoded();
                temp = temp + Base64.encodeBytes((byte[])derEncodedByte);
                temp = temp + "\n-----END CERTIFICATE-----\n";
                this.rwSocket.sendMessage(temp);
                messageFromServer = this.rwSocket.recvMessage();
                log.debug("From server " + messageFromServer);
                if (messageFromServer.equals("more")) continue;
                throw new Exception("Failed to send cert chain to the server");
            }
            this.rwSocket.sendMessage("done");
            messageFromServer = this.rwSocket.recvMessage();
            log.debug("From server " + messageFromServer);
            if (messageFromServer.equals("no")) {
                this.rwSocket.sendMessage("more");
                messageFromServer = this.rwSocket.recvMessage();
                log.debug("The Reason " + messageFromServer);
            } else {
                if (messageFromServer.equals("yes")) {
                    this.rwSocket.sendMessage("more");
                    messageFromServer = this.rwSocket.recvMessage();
                    log.debug("The Resource " + messageFromServer);
                }
                record = new gPlazmaAuthorizationRecord();
            }
        }
        catch (Exception e) {
            log.error("Exception in finding SAZ Authorization : " + messageFromServer + "\n" + e);
            this.rwSocket.closeAll();
            throw new AuthorizationException(messageFromServer + "\n" + e.toString());
        }
        this.rwSocket.closeAll();
        return record;
    }

    @Override
    public gPlazmaAuthorizationRecord authorize(String subjectDN, String role, X509Certificate[] chain, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        return null;
    }

    public void sendRequest(X509Certificate[] certs) throws Exception {
    }
}

