/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.samlquery;

import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.samlquery.SAMLAuthorizationPlugin;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import gplazma.authz.util.HostUtil;
import gplazma.authz.util.X509CertUtil;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.glite.voms.VOMSAttribute;
import org.opensciencegrid.authz.xacml.client.MapCredentialsClient;
import org.opensciencegrid.authz.xacml.common.LocalId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XACMLAuthorizationPlugin
extends SAMLAuthorizationPlugin {
    private static final HashMap<String, TimedLocalId> UsernameMap = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(XACMLAuthorizationPlugin.class);

    public XACMLAuthorizationPlugin(String mappingServiceURL, String storageAuthzPath, long authRequestID) {
        super(mappingServiceURL, storageAuthzPath, authRequestID);
        logger.info("xacml-vo-mapping plugin now loaded for URL " + mappingServiceURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public gPlazmaAuthorizationRecord authorize(String X509Subject, String fqan, X509Certificate[] chain, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        String resourceX509ID;
        String CondorCanonicalNameID = null;
        String X509SubjectIssuer = null;
        String VO = null;
        String VOMSSigningSubject = null;
        String VOMSSigningIssuer = null;
        String CertificateSerialNumber = null;
        String CASerialNumber = null;
        String VOMS_DNS_Port = null;
        String CertificatePoliciesOIDs = null;
        String CertificateChain = null;
        String resourceType = "http://authz-interop.org/xacml/resource/resource-type/se";
        String requestedaction = "http://authz-interop.org/xacml/action/action-type/access";
        String RSL_string = null;
        String key = X509Subject;
        try {
            X509SubjectIssuer = X509CertUtil.getSubjectX509Issuer(chain);
        }
        catch (Exception e) {
            logger.warn("Could not determine subject-x509-issuer : " + e.getMessage());
        }
        VOMSAttribute vomsAttr = null;
        if (chain != null && fqan != null) {
            vomsAttr = X509CertUtil.getVOMSAttribute(chain, fqan);
        }
        if (vomsAttr != null) {
            VO = vomsAttr.getVO();
            String X500IssuerName = vomsAttr.getAC().getIssuer().toString();
            VOMSSigningSubject = X509CertUtil.toGlobusDN(X500IssuerName);
        }
        try {
            resourceX509ID = this.getTargetServiceName();
        }
        catch (Exception e) {
            logger.error("Exception in finding targetServiceName : " + e);
            throw new AuthorizationException(e.toString());
        }
        HashMap<String, TimedLocalId> hashMap = UsernameMap;
        synchronized (hashMap) {
            LocalId localId;
            MapCredentialsClient xacmlClient;
            String resourceX509Issuer;
            String resourceDNSHostName;
            TimedLocalId tlocalId;
            if (this.getCacheLifetime() > 0L && (tlocalId = this.getUsernameMapping(key = fqan == null ? key : key.concat(fqan))) != null && tlocalId.age() < this.getCacheLifetime() && tlocalId.sameServiceName(resourceX509ID) && tlocalId.sameDesiredUserName(desiredUserName)) {
                logger.info("Using cached mapping for User with DN: " + X509Subject + " and Role " + fqan + " with Desired user name: " + desiredUserName);
                return this.getgPlazmaAuthorizationRecord(tlocalId.getLocalId(), X509Subject, fqan);
            }
            try {
                String[] hosts = HostUtil.getHosts();
                resourceDNSHostName = hosts.length > 0 ? hosts[0] : null;
            }
            catch (Exception e) {
                logger.error("Exception in finding targetServiceName : " + e);
                throw new AuthorizationException(e.toString());
            }
            try {
                resourceX509Issuer = this.getTargetServiceIssuer();
            }
            catch (Exception e) {
                logger.error("Exception in finding targetServiceIssuer : " + e);
                throw new AuthorizationException(e.toString());
            }
            logger.info("Requesting mapping for User with DN: " + X509Subject + " and Role " + fqan + " with Desired user name: " + desiredUserName);
            logger.debug("Mapping Service URL configuration: " + this.getMappingServiceURL());
            try {
                xacmlClient = new MapCredentialsClient();
                xacmlClient.setX509Subject(X509Subject);
                xacmlClient.setCondorCanonicalNameID(CondorCanonicalNameID);
                xacmlClient.setX509SubjectIssuer(X509SubjectIssuer);
                xacmlClient.setVO(VO);
                xacmlClient.setVOMSSigningSubject(VOMSSigningSubject);
                xacmlClient.setVOMSSigningIssuer(VOMSSigningIssuer);
                xacmlClient.setFqan(fqan);
                xacmlClient.setCertificateSerialNumber(CertificateSerialNumber);
                xacmlClient.setCASerialNumber(CASerialNumber);
                xacmlClient.setVOMS_DNS_Port(VOMS_DNS_Port);
                xacmlClient.setCertificatePoliciesOIDs(CertificatePoliciesOIDs);
                xacmlClient.setCertificateChain(CertificateChain);
                xacmlClient.setResourceType(resourceType);
                xacmlClient.setResourceDNSHostName(resourceDNSHostName);
                xacmlClient.setResourceX509ID(resourceX509ID);
                xacmlClient.setResourceX509Issuer(resourceX509Issuer);
                xacmlClient.setRequestedaction(requestedaction);
                xacmlClient.setRSL_string(RSL_string);
            }
            catch (Exception e) {
                logger.error("Exception in XACML mapping client instantiation: " + e);
                throw new AuthorizationException(e.toString());
            }
            try {
                localId = xacmlClient.mapCredentials(this.getMappingServiceURL());
            }
            catch (Exception e) {
                logger.error(" Exception occurred in mapCredentials: " + e);
                throw new AuthorizationException(e.toString());
            }
            if (localId == null) {
                String denied = "Permission Denied: No XACML mapping retrieved service for DN " + X509Subject + " and role " + fqan;
                logger.warn(denied);
                throw new AuthorizationException(denied);
            }
            gPlazmaAuthorizationRecord gauthrec = this.getgPlazmaAuthorizationRecord(localId, X509Subject, fqan);
            if (this.getCacheLifetime() > 0L) {
                this.putUsernameMapping(key, new TimedLocalId(localId, resourceX509ID, desiredUserName));
            }
            return gauthrec;
        }
    }

    private gPlazmaAuthorizationRecord getgPlazmaAuthorizationRecord(LocalId localId, String subjectDN, String role) throws AuthorizationException {
        int gid;
        int uid;
        String username = localId.getUserName();
        if (username != null) {
            logger.info("xacml-vo-mapping service returned Username: " + username);
            gPlazmaAuthorizationRecord gauthrec = this.getgPlazmaAuthorizationRecord(username, subjectDN, role);
            return gauthrec;
        }
        if (localId.getUID() == null || localId.getGID() == null) {
            String denied = "Permission Denied: XACML mapping returned a null username and no uid or gid for DN " + subjectDN + " amd role " + role;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        logger.info("xacml-vo-mapping service returned uid:primarygid " + localId.getUID() + ":" + localId.getGID());
        username = localId.getUID() + ":" + localId.getGID();
        gPlazmaAuthorizationRecord gauthrec = this.getgPlazmaAuthorizationRecord(username, subjectDN, role);
        try {
            uid = Integer.decode(localId.getUID());
            gid = Integer.decode(localId.getGID());
        }
        catch (NumberFormatException nfe) {
            String denied = "Permission Denied:  could not be decoded to an integer";
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        if (gauthrec.getUID() != uid || gauthrec.getGID() != gid) {
            String denied = "Permission Denied: uid or gid from mapping service did not match uid or gid of authorization record";
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        String[] secndgids = localId.getSecondaryGIDs();
        if (secndgids != null && secndgids.length > 0) {
            int[] authzgids = gauthrec.getGIDs();
            LinkedHashSet<String> allGIDs = new LinkedHashSet<String>(authzgids.length + secndgids.length);
            for (int gidl : authzgids) {
                allGIDs.add(Integer.toString(gidl));
            }
            allGIDs.addAll(Arrays.asList(secndgids));
            int numGIDs = allGIDs.size();
            if (numGIDs != authzgids.length) {
                int[] newGIDs = new int[numGIDs];
                Iterator GIDsIter = allGIDs.iterator();
                int i = 0;
                while (GIDsIter.hasNext()) {
                    newGIDs[i++] = Integer.decode((String)GIDsIter.next());
                }
                gauthrec = new gPlazmaAuthorizationRecord(gauthrec.getUsername(), gauthrec.isReadOnly(), gauthrec.getPriority(), gauthrec.getUID(), newGIDs, gauthrec.getHome(), gauthrec.getRoot(), gauthrec.getFsRoot());
            }
        }
        return gauthrec;
    }

    private synchronized void putUsernameMapping(String key, TimedLocalId tlocalId) {
        UsernameMap.put(key, tlocalId);
    }

    private synchronized TimedLocalId getUsernameMapping(String key) {
        return UsernameMap.get(key);
    }

    private class TimedLocalId
    extends LocalId {
        LocalId id;
        long timestamp;
        String serviceName = null;
        String desiredUserName = null;

        TimedLocalId(LocalId id) {
            this.id = id;
            this.timestamp = System.currentTimeMillis();
        }

        TimedLocalId(LocalId id, String serviceName, String desiredUserName) {
            this(id);
            this.serviceName = serviceName;
            this.desiredUserName = desiredUserName;
        }

        private LocalId getLocalId() {
            return this.id;
        }

        private long age() {
            return System.currentTimeMillis() - this.timestamp;
        }

        private boolean sameServiceName(String requestServiceName) {
            return this.serviceName.equals(requestServiceName);
        }

        private boolean sameDesiredUserName(String requestDesiredUserName) {
            if (this.desiredUserName == null && requestDesiredUserName == null) {
                return true;
            }
            if (this.desiredUserName == null) {
                return false;
            }
            return this.desiredUserName.equals(requestDesiredUserName);
        }
    }
}

