/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.samlquery;

import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.RecordMappingPlugin;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import gplazma.authz.util.X509CertUtil;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SAMLAuthorizationPlugin
extends RecordMappingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SAMLAuthorizationPlugin.class);
    private String mappingServiceURL;
    private GlobusCredential serviceCredential;
    private String targetServiceName;
    private String targetServiceIssuer;
    private static final String service_key = "/etc/grid-security/hostkey.pem";
    private static final String service_cert = "/etc/grid-security/hostcert.pem";
    private static final String service_CAFiles = "/etc/grid-security/certificates/*.0";
    private static final String service_keyPasswd = null;
    GSSContext context;
    String desiredUserName;
    String serviceUrl;
    Socket socket;

    public SAMLAuthorizationPlugin(String mappingServiceURL, String storageAuthzPath, long authRequestID) {
        super(storageAuthzPath, authRequestID);
        this.mappingServiceURL = mappingServiceURL;
        this.setSslProperties();
    }

    public String getMappingServiceURL() {
        return this.mappingServiceURL;
    }

    public String getTargetServiceName() throws GSSException {
        if (this.targetServiceName == null) {
            if (this.serviceCredential == null) {
                try {
                    this.serviceCredential = new GlobusCredential(service_cert, service_key);
                }
                catch (GlobusCredentialException gce) {
                    throw new GSSException(13, 0, "could not load host globus credentials " + gce.toString());
                }
            }
            this.targetServiceName = this.serviceCredential.getIdentity();
        }
        return this.targetServiceName;
    }

    public String getTargetServiceIssuer() throws GSSException {
        if (this.targetServiceIssuer == null) {
            if (this.serviceCredential == null) {
                try {
                    this.serviceCredential = new GlobusCredential(service_cert, service_key);
                }
                catch (GlobusCredentialException gce) {
                    throw new GSSException(13, 0, "could not load host globus credentials " + gce.toString());
                }
            }
            this.targetServiceIssuer = X509CertUtil.toGlobusDN(this.serviceCredential.getIssuer());
        }
        return this.targetServiceIssuer;
    }

    public gPlazmaAuthorizationRecord authorize(GSSContext context, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        String fqanValue;
        String gssIdentity;
        this.context = context;
        this.desiredUserName = desiredUserName;
        logger.debug("Extracting Subject DN and Role from GSSContext");
        if (!(context instanceof ExtendedGSSContext)) {
            logger.error("Received context not instance of ExtendedGSSContext, Plugin exiting ...");
            return null;
        }
        ExtendedGSSContext extendedcontext = (ExtendedGSSContext)context;
        try {
            gssIdentity = ((Object)context.getSrcName()).toString();
        }
        catch (GSSException gsse) {
            logger.error("Caught GSSException in getting DN " + gsse);
            return null;
        }
        try {
            Iterator<String> fqans = X509CertUtil.getFQANsFromContext(extendedcontext).iterator();
            fqanValue = fqans.hasNext() ? fqans.next() : "";
        }
        catch (Exception gsse) {
            logger.error("Caught Exception in extracting group and role " + gsse);
            return null;
        }
        return this.authorize(gssIdentity, fqanValue, null, desiredUserName, serviceUrl, socket);
    }

    @Override
    public abstract gPlazmaAuthorizationRecord authorize(String var1, String var2, X509Certificate[] var3, String var4, String var5, Socket var6) throws AuthorizationException;

    private void setSslProperties() {
        if (service_CAFiles != null) {
            System.setProperty("sslCAFiles", service_CAFiles);
        }
        if (service_cert != null) {
            System.setProperty("sslCertfile", service_cert);
        }
        if (service_key != null) {
            System.setProperty("sslKey", service_key);
        }
        if (service_keyPasswd != null) {
            System.setProperty("sslKeyPasswd", service_keyPasswd);
        }
    }
}

