/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.samlquery;

import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.samlquery.SAMLAuthorizationPlugin;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import java.net.Socket;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.opensciencegrid.authz.client.PRIMAAuthzModule;
import org.opensciencegrid.authz.common.LocalId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1AuthorizationPlugin
extends SAMLAuthorizationPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SAML1AuthorizationPlugin.class);
    private static final HashMap<String, TimedLocalId> UsernameMap = new HashMap();

    public SAML1AuthorizationPlugin(String mappingServiceURL, String storageAuthzPath, long authRequestID) {
        super(mappingServiceURL, storageAuthzPath, authRequestID);
        logger.info("saml-vo-mapping plugin now loaded for URL " + mappingServiceURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public gPlazmaAuthorizationRecord authorize(String subjectDN, String role, X509Certificate[] chain, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        LocalId localId;
        String serviceName;
        this.desiredUserName = desiredUserName;
        try {
            serviceName = this.getTargetServiceName();
        }
        catch (Exception e) {
            logger.error("Exception in finding targetServiceName : " + e);
            throw new AuthorizationException(e.toString());
        }
        String key = subjectDN;
        HashMap<String, TimedLocalId> hashMap = UsernameMap;
        synchronized (hashMap) {
            PRIMAAuthzModule authVO;
            TimedLocalId tlocalId;
            if (this.getCacheLifetime() > 0L && (tlocalId = this.getUsernameMapping(key = role == null ? key : key.concat(role))) != null && tlocalId.age() < this.getCacheLifetime() && tlocalId.sameServiceName(serviceName) && tlocalId.sameDesiredUserName(desiredUserName)) {
                logger.info("Using cached mapping for User with DN: " + subjectDN + " and Role " + role + " with Desired user name: " + desiredUserName);
                gPlazmaAuthorizationRecord gauthrec = this.getgPlazmaAuthorizationRecord(tlocalId.getLocalId(), subjectDN, role);
                return gauthrec;
            }
            logger.info("Requesting mapping for User with DN: " + subjectDN + " and Role " + role + " with Desired user name: " + desiredUserName);
            logger.debug("Mapping Service URL configuration: " + this.getMappingServiceURL());
            try {
                URL mappingServiceURLobject = new URL(this.getMappingServiceURL());
                authVO = new PRIMAAuthzModule(mappingServiceURLobject);
            }
            catch (Exception e) {
                logger.error("Exception in VO mapping client instantiation: " + e);
                throw new AuthorizationException(e.toString());
            }
            try {
                localId = authVO.mapCredentials(subjectDN, role, serviceName, desiredUserName);
            }
            catch (Exception e) {
                logger.error(" Exception occurred in mapCredentials: " + e);
                throw new AuthorizationException(e.toString());
            }
            if (localId == null) {
                String denied = "Permission Denied: No mapping retrieved service for DN " + subjectDN + " and role " + role;
                logger.warn(denied);
                throw new AuthorizationException(denied);
            }
            if (this.getCacheLifetime() > 0L) {
                this.putUsernameMapping(key, new TimedLocalId(localId, serviceName, desiredUserName));
            }
        }
        gPlazmaAuthorizationRecord gauthrec = this.getgPlazmaAuthorizationRecord(localId, subjectDN, role);
        return gauthrec;
    }

    private gPlazmaAuthorizationRecord getgPlazmaAuthorizationRecord(LocalId localId, String subjectDN, String role) throws AuthorizationException {
        String username = localId.getUserName();
        if (username == null) {
            String denied = "Permission Denied: non-null user record received, but with a null username";
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        logger.info("saml-vo-mapping service returned Username: " + username);
        return this.getgPlazmaAuthorizationRecord(username, subjectDN, role);
    }

    private synchronized void putUsernameMapping(String key, TimedLocalId tlocalId) {
        UsernameMap.put(key, tlocalId);
    }

    private synchronized TimedLocalId getUsernameMapping(String key) {
        return UsernameMap.get(key);
    }

    private class TimedLocalId
    extends LocalId {
        LocalId id;
        long timestamp;
        String serviceName = null;
        String desiredUserName = null;

        TimedLocalId(LocalId id) {
            this.id = id;
            this.timestamp = System.currentTimeMillis();
        }

        TimedLocalId(LocalId id, String serviceName, String desiredUserName) {
            this(id);
            this.serviceName = serviceName;
            this.desiredUserName = desiredUserName;
        }

        private LocalId getLocalId() {
            return this.id;
        }

        private long age() {
            return System.currentTimeMillis() - this.timestamp;
        }

        private boolean sameServiceName(String requestServiceName) {
            return this.serviceName.equals(requestServiceName);
        }

        private boolean sameDesiredUserName(String requestDesiredUserName) {
            if (this.desiredUserName == null && requestDesiredUserName == null) {
                return true;
            }
            if (this.desiredUserName == null) {
                return false;
            }
            return this.desiredUserName.equals(requestDesiredUserName);
        }
    }
}

