/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.gridmapfile;

import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.RecordMappingPlugin;
import gplazma.authz.plugins.gridmapfile.GridMapFile;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import java.io.File;
import java.net.Socket;
import java.security.cert.X509Certificate;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridMapFileAuthzPlugin
extends RecordMappingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(GridMapFileAuthzPlugin.class);
    private static final String GRIDMAP_FILENAME = "grid-mapfile";
    private static GridMapFile gridmap;
    gPlazmaAuthorizationRecord authRecord;
    GSSContext context;
    String desiredUserName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridMapFileAuthzPlugin(String gridMapFilePath, String storageAuthzPath, long authRequestID) {
        super(storageAuthzPath, authRequestID);
        logger.info("grid-mapfile plugin will use {}", (Object)gridMapFilePath);
        Class<GridMapFileAuthzPlugin> clazz = GridMapFileAuthzPlugin.class;
        synchronized (GridMapFileAuthzPlugin.class) {
            if (gridmap == null) {
                File file = new File(gridMapFilePath);
                if (!file.getName().equals(GRIDMAP_FILENAME)) {
                    logger.warn("The grid-mapfile filename {} is not as expected.", (Object)file);
                    logger.warn("WARNING: Possible security violation.");
                }
                gridmap = new GridMapFile(file);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    public gPlazmaAuthorizationRecord authorize(GSSContext context, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        String subjectDN;
        this.context = context;
        try {
            GSSName GSSId = context.getSrcName();
            subjectDN = ((Object)GSSId).toString();
            logger.info("Subject DN from GSSContext extracted as: " + subjectDN);
        }
        catch (GSSException gsse) {
            logger.error(" Error extracting Subject DN from GSSContext: " + gsse);
            throw new AuthorizationException(gsse.toString());
        }
        return this.authorize(subjectDN, null, null, desiredUserName, serviceUrl, socket);
    }

    @Override
    public gPlazmaAuthorizationRecord authorize(String subjectDN, String role, X509Certificate[] chain, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        String user_name;
        this.desiredUserName = desiredUserName;
        gridmap.refresh();
        if (desiredUserName != null) {
            logger.debug("Desired Username requested as: " + desiredUserName);
        }
        logger.info("Requesting mapping for User with DN: " + subjectDN);
        try {
            user_name = gridmap.getMappedUsername(subjectDN);
        }
        catch (Exception e) {
            throw new AuthorizationException(e.toString());
        }
        logger.info("Subject DN is mapped to Username: " + user_name);
        if (user_name == null) {
            String denied = "Permission Denied: Cannot determine Username from grid-mapfile for DN " + subjectDN;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        if (desiredUserName != null && !user_name.equals(desiredUserName)) {
            String denied = "Permission Denied: Requested username " + desiredUserName + " does not match returned username " + user_name + " for " + subjectDN;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        gPlazmaAuthorizationRecord gauthrec = this.getgPlazmaAuthorizationRecord(user_name, subjectDN, role);
        return gauthrec;
    }
}

