/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.dynamic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIDMapFileHandler {
    private static final Logger log = LoggerFactory.getLogger(UIDMapFileHandler.class);
    private static final String UIDMAP_FILENAME = "grid-uidmap";
    private HashMap uidMap = new HashMap();
    private static HashMap uidMap_static;
    private static long prev_refresh_time;

    public UIDMapFileHandler(String filename) throws IOException {
        try {
            String fileSeparator = System.getProperty("file.separator");
            String[] testFilenamePath = filename.split(fileSeparator);
            String testFilename = testFilenamePath[testFilenamePath.length - 1];
            if (!testFilename.equals(UIDMAP_FILENAME)) {
                log.warn("The grid-uidmap filename " + testFilename + " is not as expected.");
                log.warn("WARNING: Possible security violation.");
            }
        }
        catch (Exception se) {
            log.error("Exception in testing file: " + se);
        }
        log.debug("UIDMapFileHandler reading " + filename);
        this.read(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void read(String filename) throws IOException {
        boolean readable;
        long current_time = System.currentTimeMillis();
        File config = new File(filename);
        boolean bl = readable = config.canRead() || prev_refresh_time == 0L;
        if (!readable) {
            log.warn(MessageFormat.format("WARNING: Could not read grid-uidmap. Will use cached copy.", filename));
        }
        if (readable && config.lastModified() >= prev_refresh_time) {
            FileReader fr = new FileReader(config);
            BufferedReader reader = new BufferedReader(fr);
            try {
                this.read(reader);
            }
            finally {
                reader.close();
            }
            prev_refresh_time = current_time;
            uidMap_static = this.uidMap;
        } else {
            this.uidMap = uidMap_static;
        }
    }

    private void read(BufferedReader reader) throws IOException {
        String line;
        boolean eof = false;
        while ((line = reader.readLine()) != null) {
            int last_quote;
            String thisLine = line.trim();
            if (thisLine.length() == 0 || thisLine.charAt(0) != '\"' || (last_quote = (thisLine = thisLine.substring(1)).lastIndexOf(34)) == -1) continue;
            String gridSubjectDN = thisLine.substring(0, last_quote);
            String mappedUID = thisLine.substring(last_quote + 1).trim();
            if (mappedUID == null || mappedUID.length() <= 0) continue;
            this.fillMap(gridSubjectDN, mappedUID);
        }
    }

    private void fillMap(String subjectDN, String username) {
        String mapValue = username.trim();
        String mapKey = subjectDN.trim();
        this.uidMap.put(mapKey, mapValue);
    }

    private String removeQuotes(String quotedString) throws Exception {
        if (quotedString != null) {
            quotedString = quotedString.replace('\"', ' ').trim();
        }
        return quotedString;
    }

    public String getMappedUID(String gridDN) throws Exception {
        return this.removeQuotes((String)this.uidMap.get(gridDN));
    }

    static {
        prev_refresh_time = 0L;
    }
}

