/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins.dynamic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GIDMapFileHandler {
    private static final Logger log = LoggerFactory.getLogger(GIDMapFileHandler.class);
    private static final String GIDMAP_FILENAME = "grid-gidmap";
    private HashMap gidMap = new HashMap();
    private static HashMap gidMap_static;
    private static long prev_refresh_time;
    public static final String capnull = "/Capability=NULL";
    public static final int capnulllen;
    public static final String rolenull = "/Role=NULL";
    public static final int rolenulllen;

    public GIDMapFileHandler(String filename) throws IOException {
        try {
            String fileSeparator = System.getProperty("file.separator");
            String[] testFilenamePath = filename.split(fileSeparator);
            String testFilename = testFilenamePath[testFilenamePath.length - 1];
            if (!testFilename.equals(GIDMAP_FILENAME)) {
                log.warn("The grid-gidmap filename " + testFilename + " is not as expected.");
                log.warn("WARNING: Possible security violation.");
            }
        }
        catch (Exception se) {
            log.error("Exception in testing file: " + se);
        }
        log.debug("GIDMapFileHandler reading " + filename);
        this.read(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void read(String filename) throws IOException {
        boolean readable;
        long current_time = System.currentTimeMillis();
        File config = new File(filename);
        boolean bl = readable = config.canRead() || prev_refresh_time == 0L;
        if (!readable) {
            log.warn(MessageFormat.format("WARNING: Could not read grid-gidmap. Will use cached copy.", filename));
        }
        if (readable && config.lastModified() >= prev_refresh_time) {
            FileReader fr = new FileReader(config);
            BufferedReader reader = new BufferedReader(fr);
            try {
                this.read(reader);
            }
            finally {
                reader.close();
            }
            prev_refresh_time = current_time;
            gidMap_static = this.gidMap;
        } else {
            this.gidMap = gidMap_static;
        }
    }

    private void read(BufferedReader reader) throws IOException {
        String line;
        boolean eof = false;
        while ((line = reader.readLine()) != null) {
            int last_quote;
            String thisLine = line.trim();
            if (thisLine.length() == 0 || thisLine.charAt(0) != '\"' || (last_quote = (thisLine = thisLine.substring(1)).lastIndexOf(34)) == -1) continue;
            String gridRole = thisLine.substring(0, last_quote);
            String mappedGID = thisLine.substring(last_quote + 1).trim();
            if (mappedGID == null || mappedGID.length() <= 0) continue;
            this.fillMap(gridRole, mappedGID);
        }
    }

    private void fillMap(String role, String username) {
        String mapValue = username.trim();
        String mapKey = role.trim();
        this.gidMap.put(mapKey, mapValue);
    }

    private String removeQuotes(String quotedString) throws Exception {
        if (quotedString != null) {
            quotedString = quotedString.replace('\"', ' ').trim();
        }
        return quotedString;
    }

    public String getMappedGID(String gridRole) throws Exception {
        String GID = (String)this.gidMap.get(gridRole);
        if (GID == null) {
            if (gridRole.endsWith(capnull)) {
                gridRole = gridRole.substring(0, gridRole.length() - capnulllen);
            }
            if (gridRole.endsWith(rolenull)) {
                gridRole = gridRole.substring(0, gridRole.length() - rolenulllen);
            }
            GID = (String)this.gidMap.get(gridRole);
        }
        return this.removeQuotes(GID);
    }

    static {
        prev_refresh_time = 0L;
        capnulllen = capnull.length();
        rolenulllen = rolenull.length();
    }
}

