/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins;

import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.CachingPlugin;
import gplazma.authz.records.DCacheSRMauthzRecordsService;
import gplazma.authz.records.DynamicAuthorizationRecord;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecordMappingPlugin
extends CachingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(RecordMappingPlugin.class);
    public String storageAuthzPath;

    public RecordMappingPlugin(String storageAuthzPath, long authRequestID) {
        super(authRequestID);
        this.storageAuthzPath = storageAuthzPath;
        logger.debug("RecordMappingPlugin will use " + storageAuthzPath);
    }

    public String getStorageAuthzPath() {
        return this.storageAuthzPath;
    }

    public gPlazmaAuthorizationRecord getgPlazmaAuthorizationRecord(String username, String subjectDN, String role) throws AuthorizationException {
        String user;
        DCacheSRMauthzRecordsService storageRecordsServ;
        try {
            storageRecordsServ = new DCacheSRMauthzRecordsService(this.storageAuthzPath);
        }
        catch (Exception ase) {
            logger.error("Exception in reading storage-authzdb configuration file: ");
            logger.error(this.storageAuthzPath + " " + ase);
            throw new AuthorizationException(ase.toString());
        }
        gPlazmaAuthorizationRecord authRecord = storageRecordsServ.getStorageUserRecord(username);
        if (authRecord == null) {
            logger.error("No record found in {} for username {} mapped from DN {} and role {}", new Object[]{this.storageAuthzPath, username, subjectDN, role});
            throw new AuthorizationException("Permission Denied: No authorization record found for DN " + subjectDN + " and role " + role);
        }
        if (authRecord instanceof DynamicAuthorizationRecord) {
            DynamicAuthorizationRecord dynrecord = (DynamicAuthorizationRecord)authRecord;
            dynrecord.subjectDN = subjectDN;
            dynrecord.role = role;
            authRecord = this.getDynamicRecord(username, dynrecord);
        }
        if ((user = authRecord.getUsername()) == null) {
            String denied = "Permission Denied: received null username " + user;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        int uid = authRecord.getUID();
        if (uid == -1) {
            String denied = "Permission Denied: uid not found for " + user;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        int[] gids = authRecord.getGIDs();
        if (gids[0] == -1) {
            String denied = "Permission Denied: gids not found for " + user;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        String home = authRecord.getHome();
        if (home == null) {
            String denied = "Permission Denied: relative home path not found for " + user;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        String root = authRecord.getRoot();
        if (root == null) {
            String denied = "Permission Denied: root path not found for " + user;
            logger.warn(denied);
            throw new AuthorizationException(denied);
        }
        return authRecord;
    }
}

