/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins;

import gplazma.authz.plugins.AuthorizationPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingPlugin
extends AuthorizationPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CachingPlugin.class);
    long cache_lifetime = 30000L;

    public CachingPlugin(long authRequestID) {
        super(authRequestID);
    }

    public void setCacheLifetime(String lifetime_str) {
        if (lifetime_str == null || lifetime_str.length() == 0) {
            return;
        }
        try {
            this.setCacheLifetime(Long.decode(lifetime_str) * 1000L);
        }
        catch (NumberFormatException nfe) {
            logger.error("Could not format saml-vo-mapping-cache-lifetime=" + lifetime_str + " as long integer.");
        }
    }

    public void setCacheLifetime(long lifetime) {
        this.cache_lifetime = lifetime;
    }

    public long getCacheLifetime() {
        return this.cache_lifetime;
    }
}

