/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz.plugins;

import gplazma.authz.AuthorizationException;
import gplazma.authz.records.DCacheSRMauthzRecordsService;
import gplazma.authz.records.DynamicAuthorizationRecord;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class AuthorizationPlugin {
    long authRequestID;
    public static final String DENIED_MESSAGE = "Permission Denied";
    public static final String REVOCATION_MESSAGE = "Permission Denied - revocation.";

    public AuthorizationPlugin(long authRequestID) {
        this.authRequestID = authRequestID;
    }

    public long getAuthRequestID() {
        return this.authRequestID;
    }

    public abstract gPlazmaAuthorizationRecord authorize(String var1, String var2, X509Certificate[] var3, String var4, String var5, Socket var6) throws AuthorizationException;

    public String getDynamicString(String dynamic_mapper, String id_method, String subjectDN, String role) throws AuthorizationException {
        try {
            Object retobj = this.getDynamicValue(dynamic_mapper, id_method, subjectDN, role);
            return retobj == null ? null : retobj.toString();
        }
        catch (Exception e) {
            throw new AuthorizationException("Method " + id_method + " failed for DynamicMapper " + dynamic_mapper + " for DN " + subjectDN + " and role " + role);
        }
    }

    protected Integer getDynamicInteger(String dynamic_mapper, String id_method, String subjectDN, String role) throws AuthorizationException {
        String value = null;
        try {
            value = this.getDynamicString(dynamic_mapper, id_method, subjectDN, role);
            return Integer.decode(value);
        }
        catch (NumberFormatException nfe) {
            throw new AuthorizationException("Method " + id_method + " return value " + value + " not parsable to Integer for DynamicMapper " + dynamic_mapper + " for DN " + subjectDN + " and role " + role);
        }
    }

    private Object getDynamicValue(String dynamic_mapper, String id_method, String subjectDN, String role) throws AuthorizationException {
        Object ret_val;
        try {
            Method meth = (Method)DCacheSRMauthzRecordsService.getDynamicMethods().get(id_method);
            if (meth == null) {
                return null;
            }
            ret_val = meth.invoke((Object)this, subjectDN, role);
        }
        catch (InvocationTargetException ite) {
            throw new AuthorizationException("InvocationTargetException from uid mapping method " + id_method + " for DN " + subjectDN + " and role " + role);
        }
        catch (IllegalAccessException iac) {
            throw new AuthorizationException("IllegalAccessException from uid mapping method " + id_method + " for DN " + subjectDN + " and role " + role);
        }
        catch (NumberFormatException nfe) {
            throw new AuthorizationException("NumberFormatException from uid mapping method " + id_method + " for DN " + subjectDN + " and role " + role);
        }
        return ret_val;
    }

    public <T> T getDynamicValue(String dynamic_mapper, String uid_method, String subjectDN, String role, Class<T> ct) throws AuthorizationException {
        return null;
    }

    public gPlazmaAuthorizationRecord getDynamicRecord(String dynamic_mapper, DynamicAuthorizationRecord dynrecord) throws AuthorizationException {
        String subjectDN = dynrecord.subjectDN;
        String role = dynrecord.role;
        String method = null;
        try {
            DynamicAuthorizationRecord retrecord = new DynamicAuthorizationRecord(dynrecord);
            LinkedHashMap<String, String> strvals = retrecord.getStringValues();
            for (Map.Entry strval : strvals.entrySet()) {
                String key = (String)strval.getKey();
                method = (String)strval.getValue();
                String input = AuthorizationPlugin.getRegExInput(method, retrecord);
                String result = input == null ? this.getDynamicString(dynamic_mapper, method, subjectDN, role) : this.getDynamicString(dynamic_mapper, "regular_expression", method, input);
                if (result == null) continue;
                strvals.put(key, result);
            }
            return new DynamicAuthorizationRecord(retrecord);
        }
        catch (AuthorizationException ase) {
            throw ase;
        }
        catch (NumberFormatException nfe) {
            throw new AuthorizationException("NumberFormatException from uid mapping method " + method + " for DN " + subjectDN + " and role " + role);
        }
    }

    public static String getRegExInput(String method, DynamicAuthorizationRecord dynrecord) {
        if (method.startsWith("$")) {
            StringTokenizer t = new StringTokenizer(method, "/");
            int ntokens = t.countTokens();
            if (ntokens < 3) {
                return null;
            }
            String varname = t.nextToken().toLowerCase();
            return dynrecord.getStringValues().get(varname);
        }
        return null;
    }
}

