/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz;

import gplazma.authz.AuthorizationConfig;
import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.AuthorizationPlugin;
import gplazma.authz.plugins.gridmapfile.GridMapFileAuthzPlugin;
import gplazma.authz.plugins.samlquery.SAML1AuthorizationPlugin;
import gplazma.authz.plugins.samlquery.XACMLAuthorizationPlugin;
import gplazma.authz.plugins.vorolemap.VORoleMapAuthzPlugin;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationPluginLoader {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationPluginLoader.class);
    private AuthorizationConfig authConfig;
    private Vector pluginPriorityConfig;
    private long authRequestID;
    private List l = null;
    static final String external_plugin = "diskCacheV111.services.authorization.KPWDAuthorizationPlugin";
    static final Map<String, Class> plugins = new HashMap<String, Class>();

    public AuthorizationPluginLoader(AuthorizationConfig authConfig, long authRequestID) {
        this.authConfig = authConfig;
        this.authRequestID = authRequestID;
    }

    private void buildDCacheAuthzPolicy() throws AuthorizationException {
        if (this.authConfig == null) {
            return;
        }
        try {
            this.pluginPriorityConfig = this.authConfig.getpluginPriorityConfig();
            ListIterator iter = this.pluginPriorityConfig.listIterator(0);
            while (iter.hasNext()) {
                String gPLAZMALiteStorageAuthzDbPath;
                String thisSignal = (String)iter.next();
                if (thisSignal != null && thisSignal.equals(this.authConfig.getXACMLMappingSignal())) {
                    try {
                        String XACMLMapUrl;
                        try {
                            XACMLMapUrl = this.authConfig.getXACMLMappingServiceUrl();
                        }
                        catch (Exception e) {
                            log.error("Exception getting XACML Map Url from configuration : " + e);
                            throw new AuthorizationException(e.toString());
                        }
                        if (XACMLMapUrl != null && !XACMLMapUrl.equals("")) {
                            gPLAZMALiteStorageAuthzDbPath = this.authConfig.getGridVORoleStorageAuthzPath();
                            XACMLAuthorizationPlugin XACMLPlug = new XACMLAuthorizationPlugin(XACMLMapUrl, gPLAZMALiteStorageAuthzDbPath, this.authRequestID);
                            XACMLPlug.setCacheLifetime(this.authConfig.getXACMLMappingServiceCacheLifetime());
                            this.addPlugin(XACMLPlug);
                            continue;
                        }
                        log.error("VO Map Url not well-formed in configuration.");
                    }
                    catch (AuthorizationException ae) {
                        log.error("Exception : " + ae);
                    }
                    continue;
                }
                if (thisSignal != null && thisSignal.equals(this.authConfig.getVOMappingSignal())) {
                    try {
                        String VOMapUrl;
                        try {
                            VOMapUrl = this.authConfig.getVOMappingServiceUrl();
                        }
                        catch (Exception e) {
                            log.error("Exception getting VO Map Url from configuration : " + e);
                            throw new AuthorizationException(e.toString());
                        }
                        if (VOMapUrl != null && !VOMapUrl.equals("")) {
                            gPLAZMALiteStorageAuthzDbPath = this.authConfig.getGridVORoleStorageAuthzPath();
                            SAML1AuthorizationPlugin VOPlug = new SAML1AuthorizationPlugin(VOMapUrl, gPLAZMALiteStorageAuthzDbPath, this.authRequestID);
                            VOPlug.setCacheLifetime(this.authConfig.getVOMappingServiceCacheLifetime());
                            this.addPlugin(VOPlug);
                            continue;
                        }
                        log.error("VO Map Url not well-formed in configuration.");
                    }
                    catch (AuthorizationException ae) {
                        log.error("Exception : " + ae);
                    }
                    continue;
                }
                if (thisSignal != null && thisSignal.equals(this.authConfig.getGPLiteVORoleMappingSignal())) {
                    try {
                        String gPLAZMALiteVORoleMapPath;
                        try {
                            gPLAZMALiteVORoleMapPath = this.authConfig.getGridVORoleMapPath();
                            gPLAZMALiteStorageAuthzDbPath = this.authConfig.getGridVORoleStorageAuthzPath();
                        }
                        catch (Exception e) {
                            log.error("Exception getting Grid VO Role Map or Storage Authzdb paths from configuration :" + e);
                            throw new AuthorizationException(e.toString());
                        }
                        if (gPLAZMALiteVORoleMapPath != null && gPLAZMALiteStorageAuthzDbPath != null && !gPLAZMALiteVORoleMapPath.equals("") && !gPLAZMALiteStorageAuthzDbPath.equals("")) {
                            VORoleMapAuthzPlugin liteVORolePlug = new VORoleMapAuthzPlugin(gPLAZMALiteVORoleMapPath, gPLAZMALiteStorageAuthzDbPath, this.authRequestID);
                            this.addPlugin(liteVORolePlug);
                            continue;
                        }
                        log.error("Grid VO Role Map or Storage Authzdb paths not well-formed in configuration");
                    }
                    catch (AuthorizationException ae) {
                        log.error("Exception : " + ae);
                    }
                    continue;
                }
                if (thisSignal != null && thisSignal.equals(this.authConfig.getGridMapFileSignal())) {
                    try {
                        String storageAuthzDbPath;
                        String gridmapfilePath;
                        try {
                            gridmapfilePath = this.authConfig.getGridMapFilePath();
                            storageAuthzDbPath = this.authConfig.getStorageAuthzPath();
                        }
                        catch (Exception e) {
                            log.error("Exception getting GridMap or Storage Authzdb path from configuration :" + e);
                            throw new AuthorizationException(e.toString());
                        }
                        if (gridmapfilePath != null && storageAuthzDbPath != null && !gridmapfilePath.equals("") && !storageAuthzDbPath.equals("")) {
                            GridMapFileAuthzPlugin gPlug = new GridMapFileAuthzPlugin(gridmapfilePath, storageAuthzDbPath, this.authRequestID);
                            this.addPlugin(gPlug);
                            continue;
                        }
                        log.error("GridMap or Storage Authzdb paths not well-formed in configuration");
                    }
                    catch (AuthorizationException ae) {
                        log.error("Exception : " + ae);
                    }
                    continue;
                }
                if (thisSignal == null || !thisSignal.equals(this.authConfig.getKpwdSignal())) continue;
                for (String plugkey : plugins.keySet()) {
                    Class ExternalAuthorizationPlugin = plugins.get(plugkey);
                    Constructor plugin_constructor = ExternalAuthorizationPlugin.getConstructor(String.class, Long.TYPE);
                    AuthorizationPlugin plugin = (AuthorizationPlugin)plugin_constructor.newInstance(this.authConfig.getAuthConfigFileName(), this.authRequestID);
                    this.addPlugin(plugin);
                }
            }
        }
        catch (Exception cpe) {
            log.error("Exception processing Choice|Priority Configuration :" + cpe);
            throw new AuthorizationException(cpe.toString());
        }
    }

    public Iterator getPlugins() throws AuthorizationException {
        if (this.l == null) {
            this.l = new LinkedList();
            try {
                this.buildDCacheAuthzPolicy();
            }
            catch (AuthorizationException aue) {
                log.error("Exception in building DCache Authz Policy: " + aue);
                throw new AuthorizationException(aue.toString());
            }
            if (this.l.size() == 0) {
                log.warn("All Authorization OFF!  System Quasi-firewalled!");
            }
        }
        return this.l.listIterator(0);
    }

    private void addPlugin(AuthorizationPlugin plugin) throws AuthorizationException {
        try {
            if (plugin == null) {
                log.error("Plugin is null and cannot be added.");
            } else {
                this.l.add(plugin);
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("authRequestID " + this.authRequestID + " Exception adding Plugin: " + e);
        }
    }

    static {
        try {
            Class<?> ExternalAuthorizationPlugin = Class.forName(external_plugin);
            try {
                Constructor<?> plugin_constructor = ExternalAuthorizationPlugin.getConstructor(String.class, Long.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                log.warn("No constructor with int parameter for ExternalAuthorizationPlugin diskCacheV111.services.authorization.KPWDAuthorizationPlugin");
            }
            plugins.put(external_plugin, ExternalAuthorizationPlugin);
        }
        catch (ClassNotFoundException cnfe) {
            log.warn("ClassNotFoundException for ExternalAuthorizationPlugin diskCacheV111.services.authorization.KPWDAuthorizationPlugin");
        }
    }
}

