/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz;

import com.google.common.collect.Lists;
import gplazma.authz.AuthorizationConfig;
import gplazma.authz.AuthorizationException;
import gplazma.authz.AuthorizationPluginLoader;
import gplazma.authz.plugins.AuthorizationPlugin;
import gplazma.authz.plugins.saz.SAZAuthorizationPlugin;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import gplazma.authz.util.HostUtil;
import gplazma.authz.util.NameRolePair;
import gplazma.authz.util.X509CertUtil;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.net.GssSocket;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationController {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationController.class);
    private AuthorizationConfig authConfig = null;
    private AuthorizationPluginLoader plugin_loader;
    public static final String GPLAZMA_SRMDCACHE_RELEASE_VERSION = "0.1-1";
    private static String service_cert = "/etc/grid-security/hostcert.pem";
    private static String service_key = "/etc/grid-security/hostkey.pem";
    private static String trusted_cacerts = "/etc/grid-security/certificates";
    private static final List<String> NO_SUPPLIED_ROLES = Lists.newArrayList((Object[])new String[]{null});
    private long authRequestID;
    private static final Random random = new Random();
    private boolean use_saz = false;
    private boolean omitEmail = false;
    public static final String capnull = "/Capability=NULL";
    public static final int capnulllen = "/Capability=NULL".length();
    public static final String rolenull = "/Role=NULL";
    public static final int rolenulllen = "/Role=NULL".length();

    public AuthorizationController() throws AuthorizationException {
        this(null, random.nextInt(Integer.MAX_VALUE));
    }

    public AuthorizationController(String authservConfigFilePath) throws AuthorizationException {
        this(authservConfigFilePath, random.nextInt(Integer.MAX_VALUE));
    }

    public AuthorizationController(long authRequestID) throws AuthorizationException {
        this(null, authRequestID);
    }

    public AuthorizationController(String authConfigFilePath, long authRequestID) throws AuthorizationException {
        this.authRequestID = authRequestID;
        try {
            this.authConfig = new AuthorizationConfig(authConfigFilePath, authRequestID);
        }
        catch (IOException ioe) {
            log.error("Exception in AuthorizationConfig instantiation :" + ioe);
            throw new AuthorizationException(ioe.toString());
        }
        this.plugin_loader = new AuthorizationPluginLoader(this.authConfig, authRequestID);
    }

    public long getAuthRequestID() {
        return this.authRequestID;
    }

    public AuthorizationPluginLoader getPluginLoader() {
        return this.plugin_loader;
    }

    public Map<NameRolePair, gPlazmaAuthorizationRecord> authorize(GSSContext context, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        X509Certificate[] chain;
        AuthorizationException authexceptions = null;
        try {
            if (!(context instanceof ExtendedGSSContext)) {
                log.error("Received context not instance of ExtendedGSSContext, AuthorizationController exiting ...");
                authexceptions = new AuthorizationException("\nException thrown by " + this.getClass().getName() + ": Received context not instance of ExtendedGSSContext");
                throw authexceptions;
            }
            ExtendedGSSContext extendedcontext = (ExtendedGSSContext)context;
            chain = (X509Certificate[])extendedcontext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
        }
        catch (Exception e) {
            log.error("AuthorizationController - Exception: " + e);
            authexceptions = new AuthorizationException("\nException thrown by " + this.getClass().getName() + ": " + e.getMessage());
            throw authexceptions;
        }
        return this.authorize(chain, desiredUserName, serviceUrl, socket);
    }

    public Map<NameRolePair, gPlazmaAuthorizationRecord> authorize(X509Certificate[] chain, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        Collection<String> roles;
        String msg;
        String subjectDN;
        AuthorizationException authexceptions = null;
        try {
            this.setUseSAZ(this.authConfig.getSazClientOn());
        }
        catch (Exception e) {
            authexceptions = new AuthorizationException("\nException thrown by " + this.authConfig.getClass().getName() + ": " + e.getMessage());
            throw authexceptions;
        }
        if (this.getUseSAZ()) {
            GSSContext context = null;
            Socket sazsocket = null;
            try {
                SAZAuthorizationPlugin sazclient = new SAZAuthorizationPlugin(this.authRequestID);
                context = HostUtil.getServiceContext(service_cert, service_key, trusted_cacerts);
                sazsocket = X509CertUtil.getGsiClientSocket(this.authConfig.getSazServerHost(), Integer.parseInt(this.authConfig.getSazServerPort()), (ExtendedGSSContext)context);
                ((GssSocket)sazsocket).setUseClientMode(true);
                gPlazmaAuthorizationRecord sazauth = sazclient.authorize(chain, desiredUserName, serviceUrl, sazsocket);
                if (sazauth == null) {
                    authexceptions = new AuthorizationException("Authorization denied by SAZ");
                    throw authexceptions;
                }
            }
            catch (Exception e) {
                authexceptions = e instanceof AuthorizationException ? new AuthorizationException(" from SAZAuthorizationPlugin : " + e.getMessage()) : new AuthorizationException(" from SAZAuthorizationPlugin : " + e);
                try {
                    if (context != null) {
                        context.dispose();
                    }
                    if (sazsocket != null) {
                        sazsocket.close();
                    }
                }
                catch (Exception de) {
                    String error = authexceptions == null ? "" : authexceptions.getMessage() + ": Exception thrown by SAZAuthorizationPlugin: " + de.getMessage();
                    authexceptions = new AuthorizationException(error);
                }
                throw authexceptions;
            }
            try {
                if (context != null) {
                    context.dispose();
                }
                if (sazsocket != null) {
                    sazsocket.close();
                }
            }
            catch (Exception de) {
                String error = authexceptions == null ? "" : authexceptions.getMessage() + ": Exception thrown by SAZAuthorizationPlugin: " + de.getMessage();
                authexceptions = new AuthorizationException(error);
            }
        }
        try {
            subjectDN = X509CertUtil.getSubjectFromX509Chain(chain, this.omitEmail);
            if (this.omitEmail) {
                log.warn("Removed email field from DN: " + subjectDN);
            }
        }
        catch (Exception e) {
            msg = e.getMessage();
            if (msg == null) {
                throw new AuthorizationException("Could not extract subject DN from certificate chain");
            }
            throw new AuthorizationException("Could not extract subject DN from certificate chain: " + msg);
        }
        try {
            roles = X509CertUtil.getFQANsFromX509Chain(chain, this.authConfig.getVOMSValidation());
        }
        catch (Exception e) {
            msg = e.getMessage();
            if (msg == null) {
                throw new AuthorizationException("for subject DN " + subjectDN);
            }
            throw new AuthorizationException("for subject DN " + subjectDN + " " + msg);
        }
        return this.authorize(subjectDN, roles, chain, desiredUserName, serviceUrl, socket);
    }

    public Map<NameRolePair, gPlazmaAuthorizationRecord> authorize(String subjectDN, Collection<String> roles, X509Certificate[] chain, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        LinkedHashMap<NameRolePair, gPlazmaAuthorizationRecord> records = new LinkedHashMap<NameRolePair, gPlazmaAuthorizationRecord>();
        Iterator plugins = this.plugin_loader.getPlugins();
        AuthorizationException authexceptions = null;
        if (roles.isEmpty()) {
            roles = NO_SUPPLIED_ROLES;
        }
        block2: while (records.isEmpty() && plugins.hasNext()) {
            AuthorizationPlugin plugin = (AuthorizationPlugin)plugins.next();
            for (String role : roles) {
                try {
                    gPlazmaAuthorizationRecord authorizationRecord = plugin.authorize(subjectDN, role, chain, desiredUserName, serviceUrl, socket);
                    records.put(new NameRolePair(subjectDN, role), authorizationRecord);
                }
                catch (AuthorizationException ex) {
                    authexceptions = authexceptions == null ? ex : new AuthorizationException(authexceptions.getMessage() + "\n" + ex.getMessage());
                }
                if (desiredUserName == null) continue;
                continue block2;
            }
        }
        if (records.isEmpty()) {
            if (authexceptions == null) {
                String denied = "Permission Denied for " + subjectDN + " and roles " + roles.toString();
                authexceptions = new AuthorizationException(denied);
            }
            throw authexceptions;
        }
        return records;
    }

    public static String getFormattedAuthRequestID(long id) {
        String idstr = String.valueOf(id);
        while (idstr.length() < 10) {
            idstr = " " + idstr;
        }
        return " " + idstr;
    }

    public void setUseSAZ(boolean boolarg) {
        this.use_saz = boolarg;
    }

    public boolean getUseSAZ() {
        return this.use_saz;
    }
}

