/*
 * Decompiled with CFR 0.152.
 */
package gplazma.authz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationConfig {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationConfig.class);
    private long authRequestID;
    private String authConfigFileName;
    public static final int MAX_PLUGINS = 5;
    public static final String XACML_MAPPING_PLUGIN_SWITCH_MARK = "xacml-vo-mapping=";
    public static final String XACML_MAPPING_PLUGIN_PRIORITY_MARK = "xacml-vo-mapping-priority=";
    public static final String XACML_MAPPING_PLUGIN_CONF_1_MARK = "XACMLmappingServiceUrl=";
    public static final String XACML_MAPPING_PLUGIN_CONF_2_MARK = "xacml-vo-mapping-cache-lifetime=";
    public static final String VO_MAPPING_PLUGIN_SWITCH_MARK = "saml-vo-mapping=";
    public static final String VO_MAPPING_PLUGIN_PRIORITY_MARK = "saml-vo-mapping-priority=";
    public static final String VO_MAPPING_PLUGIN_CONF_1_MARK = "mappingServiceUrl=";
    public static final String VO_MAPPING_PLUGIN_CONF_2_MARK = "saml-vo-mapping-cache-lifetime=";
    public static final String KPWD_PLUGIN_SWITCH_MARK = "kpwd=";
    public static final String KPWD_PLUGIN_PRIORITY_MARK = "kpwd-priority=";
    public static final String KPWD_PLUGIN_CONF_1_MARK = "kpwdPath=";
    public static final String GRIDMAPFILE_PLUGIN_SWITCH_MARK = "grid-mapfile=";
    public static final String GRIDMAPFILE_PLUGIN_PRIORITY_MARK = "grid-mapfile-priority=";
    public static final String GRIDMAPFILE_PLUGIN_CONF_1_MARK = "gridMapFilePath=";
    public static final String GRIDMAPFILE_PLUGIN_CONF_2_MARK = "storageAuthzPath=";
    public static final String GPLAZMA_LITE_VOROLE_MAPPING_PLUGIN_SWITCH_MARK = "gplazmalite-vorole-mapping=";
    public static final String GPLAZMA_LITE_VOROLE_MAPPING_PLUGIN_PRIORITY_MARK = "gplazmalite-vorole-mapping-priority=";
    public static final String GPLAZMA_LITE_VOROLE_MAPPING_CONF_1_MARK = "gridVoRolemapPath=";
    public static final String GPLAZMA_LITE_VOROLE_MAPPING_CONF_2_MARK = "gridVoRoleStorageAuthzPath=";
    public static final String GPLAZMA_LITE_VOROLE_MAPPING_CONF_3_MARK = "vomsValidation=";
    public static final String XACML_MAPPING_SIGNAL = "XACML_MAPPING_green";
    public static final String VO_MAPPING_SIGNAL = "VO_MAPPING_green";
    public static final String GRIDMAPFILE_SIGNAL = "GRIDMAPFILE_green";
    public static final String KPWD_SIGNAL = "KPWD_green";
    public static final String GPLAZMA_LITE_VOROLE_MAPPING_SIGNAL = "GPLAZMA_LITE_VOROLE_MAPPING_green";
    public static final String GPLAZMA_USE_SAZ_SWITCH_MARK = "saz-client=";
    public static final String GPLAZMA_SAZ_SERVER_HOST_MARK = "SAZ_SERVER_HOST=";
    public static final String GPLAZMA_SAZ_SERVER_PORT_MARK = "SAZ_SERVER_PORT=";
    public static final String GPLAZMA_SAZ_SERVER_DN_MARK = "SAZ_SERVER_DN=";
    private HashMap authServConfig = new HashMap();
    private static HashMap authServConfig_static;
    private static long prev_refresh_time;

    public AuthorizationConfig(String filename, long authRequestID) throws IOException {
        this.authRequestID = authRequestID;
        this.authConfigFileName = filename;
        log.debug("AuthorizationConfig reading " + filename);
        this.read(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void read(String filename) throws IOException {
        boolean readable;
        long current_time = System.currentTimeMillis();
        File config = new File(filename);
        boolean bl = readable = config.canRead() || prev_refresh_time == 0L;
        if (!readable) {
            log.warn("WARNING: Could not read policy file " + filename + ". Will use cached copy.");
        }
        if (readable && config.lastModified() >= prev_refresh_time) {
            FileReader fr = new FileReader(config);
            BufferedReader reader = new BufferedReader(fr);
            try {
                this.read(reader);
            }
            finally {
                reader.close();
            }
            prev_refresh_time = current_time;
            authServConfig_static = this.authServConfig;
        } else {
            this.authServConfig = authServConfig_static;
        }
    }

    private void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            this.parseLine(XACML_MAPPING_PLUGIN_SWITCH_MARK, line);
            this.parseLine(XACML_MAPPING_PLUGIN_PRIORITY_MARK, line);
            this.parseLine(XACML_MAPPING_PLUGIN_CONF_1_MARK, line);
            this.parseLine(XACML_MAPPING_PLUGIN_CONF_2_MARK, line);
            this.parseLine(VO_MAPPING_PLUGIN_SWITCH_MARK, line);
            this.parseLine(VO_MAPPING_PLUGIN_PRIORITY_MARK, line);
            this.parseLine(VO_MAPPING_PLUGIN_CONF_1_MARK, line);
            this.parseLine(VO_MAPPING_PLUGIN_CONF_2_MARK, line);
            this.parseLine(KPWD_PLUGIN_SWITCH_MARK, line);
            this.parseLine(KPWD_PLUGIN_PRIORITY_MARK, line);
            this.parseLine(KPWD_PLUGIN_CONF_1_MARK, line);
            this.parseLine(GRIDMAPFILE_PLUGIN_SWITCH_MARK, line);
            this.parseLine(GRIDMAPFILE_PLUGIN_PRIORITY_MARK, line);
            this.parseLine(GRIDMAPFILE_PLUGIN_CONF_1_MARK, line);
            this.parseLine(GRIDMAPFILE_PLUGIN_CONF_2_MARK, line);
            this.parseLine(GPLAZMA_LITE_VOROLE_MAPPING_PLUGIN_SWITCH_MARK, line);
            this.parseLine(GPLAZMA_LITE_VOROLE_MAPPING_PLUGIN_PRIORITY_MARK, line);
            this.parseLine(GPLAZMA_LITE_VOROLE_MAPPING_CONF_1_MARK, line);
            this.parseLine(GPLAZMA_LITE_VOROLE_MAPPING_CONF_2_MARK, line);
            this.parseLine(GPLAZMA_LITE_VOROLE_MAPPING_CONF_3_MARK, line);
            this.parseLine(GPLAZMA_USE_SAZ_SWITCH_MARK, line);
            this.parseLine(GPLAZMA_SAZ_SERVER_HOST_MARK, line);
            this.parseLine(GPLAZMA_SAZ_SERVER_PORT_MARK, line);
            this.parseLine(GPLAZMA_SAZ_SERVER_DN_MARK, line);
        }
    }

    private void parseLine(String thisMark, String thisLine) {
        if (thisLine.startsWith(thisMark)) {
            this.fillMap(thisMark, thisLine);
        }
    }

    private void fillMap(String currentMark, String currentLine) {
        String mapValue = currentLine.substring(currentMark.length()).trim();
        String mapKey = currentMark;
        this.authServConfig.put(mapKey, mapValue);
    }

    private Vector buildPriorityConfig() throws Exception {
        int priorityOfKpwd;
        int priorityOfXACMLeMapping;
        int priorityOfVOMapping;
        int priorityOfGridMapFile;
        int priorityOfGPLiteVORoleMapping;
        String switchOfXACMLMapping = this.getXACMLMappingSwitch();
        switchOfXACMLMapping = this.removeQuotes(switchOfXACMLMapping);
        String switchOfVOMapping = this.getVOMappingSwitch();
        switchOfVOMapping = this.removeQuotes(switchOfVOMapping);
        String switchOfKpwd = this.getKpwdSwitch();
        switchOfKpwd = this.removeQuotes(switchOfKpwd);
        String switchOfGridMapFile = this.getGridMapFileSwitch();
        switchOfGridMapFile = this.removeQuotes(switchOfGridMapFile);
        String switchOfGPLiteVORoleMapping = this.getGPLiteVOMappingSwitch();
        switchOfGPLiteVORoleMapping = this.removeQuotes(switchOfGPLiteVORoleMapping);
        Vector<String> pluginPriorityConfig = new Vector<String>(5, 1);
        pluginPriorityConfig.setSize(5);
        if ("ON".equals(switchOfGPLiteVORoleMapping) && (priorityOfGPLiteVORoleMapping = this.getGPLiteVORoleMappingPriority()) > 0 && priorityOfGPLiteVORoleMapping < 6) {
            pluginPriorityConfig.setElementAt(GPLAZMA_LITE_VOROLE_MAPPING_SIGNAL, priorityOfGPLiteVORoleMapping - 1);
        }
        if ("ON".equals(switchOfGridMapFile) && (priorityOfGridMapFile = this.getGridMapFilePriority()) > 0 && priorityOfGridMapFile < 6) {
            pluginPriorityConfig.setElementAt(GRIDMAPFILE_SIGNAL, priorityOfGridMapFile - 1);
        }
        if ("ON".equals(switchOfVOMapping) && (priorityOfVOMapping = this.getVOMappingPriority()) > 0 && priorityOfVOMapping < 6) {
            pluginPriorityConfig.setElementAt(VO_MAPPING_SIGNAL, priorityOfVOMapping - 1);
        }
        if ("ON".equals(switchOfXACMLMapping) && (priorityOfXACMLeMapping = this.getXACMLMappingPriority()) > 0 && priorityOfXACMLeMapping < 6) {
            pluginPriorityConfig.setElementAt(XACML_MAPPING_SIGNAL, priorityOfXACMLeMapping - 1);
        }
        if ("ON".equals(switchOfKpwd) && (priorityOfKpwd = this.getKpwdPriority()) > 0 && priorityOfKpwd < 6) {
            pluginPriorityConfig.setElementAt(KPWD_SIGNAL, priorityOfKpwd - 1);
        }
        return pluginPriorityConfig;
    }

    private String removeQuotes(String quotedString) throws Exception {
        if (quotedString != null) {
            quotedString = quotedString.replace('\"', ' ').trim();
        }
        return quotedString;
    }

    private int getXACMLMappingPriority() throws Exception {
        return this.getPriority(XACML_MAPPING_PLUGIN_PRIORITY_MARK);
    }

    private int getVOMappingPriority() throws Exception {
        return this.getPriority(VO_MAPPING_PLUGIN_PRIORITY_MARK);
    }

    private int getKpwdPriority() throws Exception {
        return this.getPriority(KPWD_PLUGIN_PRIORITY_MARK);
    }

    private int getGridMapFilePriority() throws Exception {
        return this.getPriority(GRIDMAPFILE_PLUGIN_PRIORITY_MARK);
    }

    private int getGPLiteVORoleMappingPriority() throws Exception {
        return this.getPriority(GPLAZMA_LITE_VOROLE_MAPPING_PLUGIN_PRIORITY_MARK);
    }

    private int getPriority(String thisPriorityMark) throws Exception {
        String priority = (String)this.authServConfig.get(thisPriorityMark);
        if (priority != null) {
            priority = priority.replace('\"', ' ').trim();
        }
        if (priority != null && (priority.matches("\"[\\d]\"") || priority.matches("[\\s\\d\\s]") || priority.matches("\"[\\W\\d\\W]\""))) {
            priority = priority.replace('\"', ' ').trim();
            return Integer.parseInt(priority);
        }
        return -1;
    }

    private String getXACMLMappingSwitch() {
        return (String)this.authServConfig.get(XACML_MAPPING_PLUGIN_SWITCH_MARK);
    }

    private String getVOMappingSwitch() {
        return (String)this.authServConfig.get(VO_MAPPING_PLUGIN_SWITCH_MARK);
    }

    private String getKpwdSwitch() {
        return (String)this.authServConfig.get(KPWD_PLUGIN_SWITCH_MARK);
    }

    private String getGridMapFileSwitch() {
        return (String)this.authServConfig.get(GRIDMAPFILE_PLUGIN_SWITCH_MARK);
    }

    private String getGPLiteVOMappingSwitch() {
        return (String)this.authServConfig.get(GPLAZMA_LITE_VOROLE_MAPPING_PLUGIN_SWITCH_MARK);
    }

    public String getVOMappingServiceUrl() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(VO_MAPPING_PLUGIN_CONF_1_MARK));
    }

    public String getVOMappingServiceCacheLifetime() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(VO_MAPPING_PLUGIN_CONF_2_MARK));
    }

    public String getXACMLMappingServiceUrl() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(XACML_MAPPING_PLUGIN_CONF_1_MARK));
    }

    public String getXACMLMappingServiceCacheLifetime() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(XACML_MAPPING_PLUGIN_CONF_2_MARK));
    }

    public String getKpwdPath() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(KPWD_PLUGIN_CONF_1_MARK));
    }

    public String getGridMapFilePath() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GRIDMAPFILE_PLUGIN_CONF_1_MARK));
    }

    public String getStorageAuthzPath() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GRIDMAPFILE_PLUGIN_CONF_2_MARK));
    }

    public String getGridVORoleMapPath() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GPLAZMA_LITE_VOROLE_MAPPING_CONF_1_MARK));
    }

    public String getGridVORoleStorageAuthzPath() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GPLAZMA_LITE_VOROLE_MAPPING_CONF_2_MARK));
    }

    public boolean getVOMSValidation() throws Exception {
        String switchOfVOMSValidation = this.getVOMSValidationSwitch();
        return switchOfVOMSValidation != null && !switchOfVOMSValidation.equals("") && switchOfVOMSValidation.equals("true");
    }

    private String getVOMSValidationSwitch() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GPLAZMA_LITE_VOROLE_MAPPING_CONF_3_MARK));
    }

    public Vector getpluginPriorityConfig() throws Exception {
        Vector sendpluginPriorityConfig = this.buildPriorityConfig();
        return sendpluginPriorityConfig;
    }

    public String getKpwdSignal() throws Exception {
        return KPWD_SIGNAL;
    }

    public String getXACMLMappingSignal() throws Exception {
        return XACML_MAPPING_SIGNAL;
    }

    public String getVOMappingSignal() throws Exception {
        return VO_MAPPING_SIGNAL;
    }

    public String getGridMapFileSignal() throws Exception {
        return GRIDMAPFILE_SIGNAL;
    }

    public String getGPLiteVORoleMappingSignal() throws Exception {
        return GPLAZMA_LITE_VOROLE_MAPPING_SIGNAL;
    }

    public boolean getSazClientOn() throws Exception {
        String switchOfSazClient = this.getSazClientSwitch();
        return switchOfSazClient != null && !switchOfSazClient.equals("") && switchOfSazClient.equals("ON");
    }

    private String getSazClientSwitch() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GPLAZMA_USE_SAZ_SWITCH_MARK));
    }

    public String getSazServerHost() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GPLAZMA_SAZ_SERVER_HOST_MARK));
    }

    public String getSazServerPort() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GPLAZMA_SAZ_SERVER_PORT_MARK));
    }

    public String getSazServerDN() throws Exception {
        return this.removeQuotes((String)this.authServConfig.get(GPLAZMA_SAZ_SERVER_DN_MARK));
    }

    public String getAuthConfigFileName() {
        return this.authConfigFileName;
    }

    static {
        prev_refresh_time = 0L;
    }
}

