/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.authorization;

import gplazma.authz.AuthorizationConfig;
import gplazma.authz.AuthorizationException;
import gplazma.authz.plugins.CachingPlugin;
import gplazma.authz.records.gPlazmaAuthorizationRecord;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.X509Certificate;
import org.dcache.auth.KAuthFile;
import org.dcache.auth.UserAuthRecord;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KPWDAuthorizationPlugin
extends CachingPlugin {
    private static Logger logger = LoggerFactory.getLogger(KPWDAuthorizationPlugin.class);
    private String kAuthFilePath;
    private long authRequestID = 0L;
    GSSContext context;
    String desiredUserName;
    AuthorizationConfig authConfig;

    public KPWDAuthorizationPlugin(long authRequestID) throws AuthorizationException {
        super(authRequestID);
        logger.debug("kpwd plugin now loaded");
    }

    public KPWDAuthorizationPlugin(String authConfigFilePath, long authRequestID) throws AuthorizationException {
        this(authRequestID);
        try {
            this.authConfig = new AuthorizationConfig(authConfigFilePath, authRequestID);
        }
        catch (IOException ioe) {
            logger.error("Exception in AuthorizationConfig instantiation :" + ioe);
            throw new AuthorizationException(ioe.toString(), ioe);
        }
        try {
            this.kAuthFilePath = this.authConfig.getKpwdPath();
            if (this.kAuthFilePath != null && !new File(this.kAuthFilePath).isAbsolute()) {
                this.kAuthFilePath = new File(new File(authConfigFilePath).getParentFile(), this.kAuthFilePath).getPath();
            }
        }
        catch (Exception e) {
            logger.error("Exception getting Kpwd Path from configuration :" + e);
            throw new AuthorizationException(e.toString(), e);
        }
    }

    public gPlazmaAuthorizationRecord authorize(GSSContext context, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        String subjectDN;
        this.context = context;
        try {
            GSSName GSSId = context.getSrcName();
            subjectDN = ((Object)GSSId).toString();
            logger.debug("Subject DN from GSSContext extracted as: " + subjectDN);
        }
        catch (GSSException gsse) {
            logger.error("Error extracting Subject DN from GSSContext: " + gsse);
            throw new AuthorizationException(gsse.toString(), gsse);
        }
        return this.authorize(subjectDN, null, null, desiredUserName, serviceUrl, socket);
    }

    @Override
    public gPlazmaAuthorizationRecord authorize(String subjectDN, String role, X509Certificate[] chain, String desiredUserName, String serviceUrl, Socket socket) throws AuthorizationException {
        String user_name;
        KAuthFile authF;
        logger.debug("Using dcache.kpwd configuration: " + this.kAuthFilePath);
        this.desiredUserName = desiredUserName;
        try {
            authF = new KAuthFile(this.kAuthFilePath);
        }
        catch (Exception e) {
            logger.error("Exception in KAuthFile instantiation: " + e);
            throw new AuthorizationException(e.toString(), e);
        }
        if (desiredUserName != null) {
            logger.debug("Desired Username requested as: " + desiredUserName);
            user_name = desiredUserName;
        } else {
            logger.info("Requesting mapping for User with DN: " + subjectDN);
            user_name = authF.getIdMapping(subjectDN);
            logger.info("dcache.kpwd service returned Username: " + user_name);
            if (user_name == null) {
                String denied = "Permission Denied: Cannot determine Username for DN " + subjectDN;
                logger.warn(denied);
                throw new AuthorizationException(denied);
            }
        }
        UserAuthRecord authRecord = authF.getUserRecord(user_name);
        if (authRecord == null) {
            logger.error("User " + user_name + " is not found in authorization records");
            logger.error("dcache.kpwd Authorization Service plugin: Authorization denied for user: " + user_name + " with subject DN: " + subjectDN);
            throw new AuthorizationException("User " + user_name + " is not found in authorization records");
        }
        if (!authRecord.hasSecureIdentity(subjectDN)) {
            logger.error("dcache.kpwd Authorization Service plugin: Authorization denied for user: " + user_name + " with subject DN: " + subjectDN);
            throw new AuthorizationException("dcache.kpwd Authorization Plugin: Authorization denied for user " + user_name + " with Subject DN " + subjectDN);
        }
        authRecord.DN = subjectDN;
        gPlazmaAuthorizationRecord gauthrec = KPWDAuthorizationPlugin.getgPlazmaAuthorizationRecord(authRecord);
        return gauthrec;
    }

    public static gPlazmaAuthorizationRecord getgPlazmaAuthorizationRecord(UserAuthRecord authrec) {
        if (authrec == null) {
            return new gPlazmaAuthorizationRecord();
        }
        return new gPlazmaAuthorizationRecord(authrec.Username, authrec.ReadOnly, authrec.priority, authrec.UID, authrec.GIDs, authrec.Home, authrec.Root, authrec.FsRoot);
    }
}

