/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.acl;

import org.dcache.chimera.nfs.v4.HimeraNFS4Utils;
import org.dcache.chimera.nfs.v4.xdr.aceflag4;
import org.dcache.chimera.nfs.v4.xdr.acemask4;
import org.dcache.chimera.nfs.v4.xdr.acetype4;
import org.dcache.chimera.nfs.v4.xdr.nfsace4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.utf8str_mixed;

public class Ace {
    private final nfsace4[] _ace;

    public Ace(nfsace4[] ace) {
        this._ace = ace;
    }

    public static Ace valueOf(int unixMode, boolean isDir) {
        nfsace4[] ace = new nfsace4[6];
        nfsace4 ownerAceAllow = new nfsace4();
        nfsace4 groupAceAllow = new nfsace4();
        nfsace4 otherAceAllow = new nfsace4();
        nfsace4 ownerAceDeny = new nfsace4();
        nfsace4 groupAceDeny = new nfsace4();
        nfsace4 otherAceDeny = new nfsace4();
        ace[0] = ownerAceAllow;
        ace[1] = ownerAceDeny;
        ace[2] = groupAceAllow;
        ace[3] = groupAceDeny;
        ace[4] = otherAceAllow;
        ace[5] = otherAceDeny;
        int mode = unixMode & 0x1FF;
        int maskAllow = 0;
        int maskDeny = 0;
        maskAllow = 393472;
        maskDeny = 0;
        if ((mode & 0x100) == 256) {
            maskAllow |= 1;
        } else {
            maskDeny |= 1;
        }
        if ((mode & 0x80) == 128) {
            maskAllow |= 6;
            if (isDir) {
                maskAllow |= 0x40;
            }
        } else {
            maskDeny |= 6;
            if (isDir) {
                maskDeny |= 0x40;
            }
        }
        if ((mode & 0x40) == 64) {
            maskAllow |= 0x20;
        } else {
            maskDeny |= 0x20;
        }
        ownerAceAllow.access_mask = new acemask4(new uint32_t(maskAllow));
        ownerAceAllow.type = new acetype4(new uint32_t(0));
        ownerAceAllow.flag = new aceflag4(new uint32_t(0));
        ownerAceAllow.who = new utf8str_mixed("OWNER@");
        ownerAceDeny.access_mask = new acemask4(new uint32_t(maskDeny));
        ownerAceDeny.type = new acetype4(new uint32_t(1));
        ownerAceDeny.flag = new aceflag4(new uint32_t(0));
        ownerAceDeny.who = new utf8str_mixed("OWNER@");
        maskAllow = 0;
        maskDeny = 0;
        if ((mode & 0x20) == 32) {
            maskAllow |= 1;
        } else {
            maskDeny |= 1;
        }
        if ((mode & 0x10) == 16) {
            maskAllow |= 6;
            if (isDir) {
                maskAllow |= 0x40;
            }
        } else {
            maskDeny |= 6;
            if (isDir) {
                maskDeny |= 0x40;
            }
        }
        if ((mode & 8) == 8) {
            maskAllow |= 0x20;
        } else {
            maskDeny |= 0x20;
        }
        groupAceAllow.access_mask = new acemask4(new uint32_t(maskAllow));
        groupAceAllow.type = new acetype4(new uint32_t(0));
        groupAceAllow.flag = new aceflag4(new uint32_t(0));
        groupAceAllow.who = new utf8str_mixed("GROUP@");
        groupAceDeny.access_mask = new acemask4(new uint32_t(maskDeny));
        groupAceDeny.type = new acetype4(new uint32_t(1));
        groupAceDeny.flag = new aceflag4(new uint32_t(0));
        groupAceDeny.who = new utf8str_mixed("GROUP@");
        maskAllow = 0;
        maskDeny = 0;
        if ((mode & 4) == 4) {
            maskAllow |= 1;
        } else {
            maskDeny |= 1;
        }
        if ((mode & 2) == 2) {
            maskAllow |= 6;
            if (isDir) {
                maskAllow |= 0x40;
            }
        } else {
            maskDeny |= 6;
            if (isDir) {
                maskDeny |= 0x40;
            }
        }
        if ((mode & 1) == 1) {
            maskAllow |= 0x20;
        } else {
            maskDeny |= 0x20;
        }
        otherAceAllow.access_mask = new acemask4(new uint32_t(maskAllow));
        otherAceAllow.type = new acetype4(new uint32_t(0));
        otherAceAllow.flag = new aceflag4(new uint32_t(0));
        otherAceAllow.who = new utf8str_mixed("EVERYONE@");
        otherAceDeny.access_mask = new acemask4(new uint32_t(maskDeny));
        otherAceDeny.type = new acetype4(new uint32_t(1));
        otherAceDeny.flag = new aceflag4(new uint32_t(0));
        otherAceDeny.who = new utf8str_mixed("EVERYONE@");
        return new Ace(ace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (nfsace4 ace : this._ace) {
            sb.append(HimeraNFS4Utils.aceToString(ace)).append("\n");
        }
        return sb.toString();
    }

    public nfsace4[] getNfs4Ace() {
        return this._ace;
    }

    public static void main(String[] args) {
        System.out.println(Ace.valueOf(420, false));
    }
}

