/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.WRITE4res;
import org.dcache.chimera.nfs.v4.xdr.WRITE4resok;
import org.dcache.chimera.nfs.v4.xdr.count4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationWRITE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationWRITE.class);

    public OperationWRITE(nfs_argop4 args) {
        super(args, 38);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        WRITE4res res = new WRITE4res();
        try {
            if (this._args.opwrite.offset.value.value + (long)this._args.opwrite.data.remaining() > 0x3FFFFFFEL) {
                throw new ChimeraNFSException(22, "Arbitrary value");
            }
            if (context.currentInode().isDirectory()) {
                throw new ChimeraNFSException(21, "path is a directory");
            }
            if (context.currentInode().isLink()) {
                throw new ChimeraNFSException(22, "path is a symlink");
            }
            Stat inodeStat = context.currentInode().statCache();
            UnixAcl fileAcl = new UnixAcl(inodeStat.getUid(), inodeStat.getGid(), inodeStat.getMode() & 0x1FF);
            if (!context.getAclHandler().isAllowed((Acl)fileAcl, (User)context.getUser(), 2)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            if (context.getSession() == null) {
                context.getStateHandler().updateClientLeaseTime(this._args.opwrite.stateid);
            } else {
                context.getSession().getClient().updateLeaseTime();
            }
            long offset = this._args.opwrite.offset.value.value;
            int count = this._args.opwrite.data.remaining();
            byte[] data = new byte[count];
            this._args.opwrite.data.get(data);
            int bytesWritten = context.currentInode().write(offset, data, 0, count);
            if (bytesWritten < 0) {
                throw new IOHimeraFsException("IO not allowed");
            }
            res.status = 0;
            res.resok4 = new WRITE4resok();
            res.resok4.count = new count4(new uint32_t(bytesWritten));
            res.resok4.committed = 2;
            res.resok4.writeverf = new verifier4();
            res.resok4.writeverf.value = new byte[8];
        }
        catch (IOHimeraFsException hioe) {
            _log.debug("WRITE: {}", (Object)hioe.getMessage());
            res.status = 5;
        }
        catch (ChimeraNFSException he) {
            _log.debug("WRITE: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (ChimeraFsException hfe) {
            res.status = 10020;
        }
        this._result.opwrite = res;
        return this._result;
    }
}

